/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.util.EncodeUtils;

public class EnumEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EnumType type = context.getTypeAnnotation(EnumType.class);
        Enum value = context.getValue(Enum.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), type.protocolType(), type.fieldName(), value);
    }

    public <T extends Enum> void encode(@NonNull byte[] datagram, int byteOffset, EndianPolicy policy, @NonNull ProtocolType protocolType, @NonNull String fieldName, @NonNull T value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolType == null) {
            throw new NullPointerException("protocolType is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int code = 0;
        if (fieldName == null || fieldName.isEmpty()) {
            code = value.ordinal();
        } else {
            try {
                Field field = value.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                code = field.getInt(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new EncodeException(MessageFormat.format(CodecError.ILLEGAL_ENUM_CODE_FIELD.getMessage(), fieldName), (Throwable)e);
            }
        }
        if (protocolType == ProtocolType.UINTEGER8) {
            EncodeUtils.uInteger8Type(datagram, byteOffset, code);
        } else if (protocolType == ProtocolType.UINTEGER16) {
            EncodeUtils.uInteger16Type(datagram, byteOffset, policy, code);
        } else if (protocolType == ProtocolType.INTEGER) {
            EncodeUtils.integerType(datagram, byteOffset, policy, code);
        } else {
            throw new EncodeException(CodecError.INVALID_ENUM_PROTOCOL_TYPE);
        }
    }
}

