/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.ReverseUtils;

public class FloatEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        FloatType type = context.getTypeAnnotation(FloatType.class);
        Float value = context.getValue(Float.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value.floatValue());
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy endian, float value) {
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 4 > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        int bits = Float.floatToIntBits(value);
        if (endian == EndianPolicy.LITTLE) {
            datagram[bo] = (byte)bits;
            datagram[bo + 1] = (byte)(bits >>> 8);
            datagram[bo + 2] = (byte)(bits >>> 16);
            datagram[bo + 3] = (byte)(bits >>> 24);
        } else if (endian == EndianPolicy.BIG) {
            datagram[bo + 3] = (byte)bits;
            datagram[bo + 2] = (byte)(bits >>> 8);
            datagram[bo + 1] = (byte)(bits >>> 16);
            datagram[bo] = (byte)(bits >>> 24);
        }
    }
}

