/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ListType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.EncodeUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ListEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ListType type = context.getTypeAnnotation(ListType.class);
        this.encode(context.getDatagram(), type.value(), type.length(), type.protocolType(), context.getEndianPolicy(), (List)context.getValue());
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull ProtocolType type, @NonNull EndianPolicy policy, List<?> values) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new EncodeException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        Consumer<BiConsumer> codec = consumer -> IntStream.range(0, length).parallel().forEach(i -> consumer.accept(i * size + byteOffset, i));
        switch (type) {
            case CHARACTER: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, ((Character)values.get((int)i)).charValue()));
                break;
            }
            case BYTE: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, ((Byte)values.get((int)i)).byteValue()));
                break;
            }
            case SHORT: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, (Short)values.get((int)i)));
                break;
            }
            case INTEGER: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, (Integer)values.get((int)i)));
                break;
            }
            case LONG: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, (Long)values.get((int)i)));
                break;
            }
            case UINTEGER8: {
                codec.accept((b, i) -> EncodeUtils.uInteger8Type(datagram, b, (Integer)values.get((int)i)));
                break;
            }
            case UINTEGER16: {
                codec.accept((b, i) -> EncodeUtils.uInteger16Type(datagram, b, policy, (Integer)values.get((int)i)));
                break;
            }
            case UINTEGER32: {
                codec.accept((b, i) -> EncodeUtils.uInteger32Type(datagram, b, policy, (Long)values.get((int)i)));
                break;
            }
            case INTEGER8: {
                codec.accept((b, i) -> EncodeUtils.integer8Type(datagram, b, (Integer)values.get((int)i)));
                break;
            }
            case INTEGER16: {
                codec.accept((b, i) -> EncodeUtils.integer16Type(datagram, b, policy, (Integer)values.get((int)i)));
                break;
            }
            case FLOAT: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, ((Float)values.get((int)i)).floatValue()));
                break;
            }
            case DOUBLE: {
                codec.accept((b, i) -> EncodeUtils.type(datagram, (int)b, policy, (Double)values.get((int)i)));
                break;
            }
            default: {
                throw new EncodeException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
            }
        }
    }
}

