/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.ValidationContext;
import org.indunet.fastproto.pipeline.decode.DecodeFlow;
import org.indunet.fastproto.pipeline.decode.DecryptFlow;
import org.indunet.fastproto.pipeline.decode.UncompressFlow;
import org.indunet.fastproto.pipeline.decode.VerifyChecksumFlow;
import org.indunet.fastproto.pipeline.decode.VerifyFixedLengthFlow;
import org.indunet.fastproto.pipeline.decode.VerifyProtocolVersionFlow;
import org.indunet.fastproto.pipeline.encode.CompressFlow;
import org.indunet.fastproto.pipeline.encode.EncodeFlow;
import org.indunet.fastproto.pipeline.encode.EncryptFlow;
import org.indunet.fastproto.pipeline.encode.FixedLengthFlow;
import org.indunet.fastproto.pipeline.encode.InferLengthFlow;
import org.indunet.fastproto.pipeline.encode.WriteChecksumFlow;
import org.indunet.fastproto.pipeline.encode.WriteProtocolVersionFlow;
import org.indunet.fastproto.pipeline.validate.ArrayFlow;
import org.indunet.fastproto.pipeline.validate.DecodeFormulaFlow;
import org.indunet.fastproto.pipeline.validate.EncodeFormulaFlow;
import org.indunet.fastproto.pipeline.validate.FieldFlow;
import org.indunet.fastproto.pipeline.validate.TimestampFlow;

public abstract class AbstractFlow<T> {
    protected static Class<? extends AbstractFlow>[] decodeFlowClasses = new Class[]{DecryptFlow.class, UncompressFlow.class, VerifyFixedLengthFlow.class, VerifyChecksumFlow.class, VerifyProtocolVersionFlow.class, DecodeFlow.class};
    protected static Class<? extends AbstractFlow>[] encodeFlowClasses = new Class[]{InferLengthFlow.class, FixedLengthFlow.class, EncodeFlow.class, WriteProtocolVersionFlow.class, WriteChecksumFlow.class, CompressFlow.class, EncryptFlow.class};
    AbstractFlow<T> next = null;
    protected static ConcurrentMap<Long, AbstractFlow> decodeFlows = new ConcurrentHashMap<Long, AbstractFlow>();
    protected static ConcurrentMap<Long, AbstractFlow> encodeFlows = new ConcurrentHashMap<Long, AbstractFlow>();
    protected static AbstractFlow<ValidationContext> validateFlow;

    public abstract void process(T var1);

    public AbstractFlow<T> setNext(AbstractFlow<T> next) {
        this.next = next;
        return this.next;
    }

    public void nextFlow(T context) {
        if (this.next != null) {
            this.next.process(context);
        }
    }

    public void end() {
        this.next = null;
    }

    public abstract long getFlowCode();

    public static AbstractFlow<CodecContext> getDecodeFlow(long codecFeature) {
        return decodeFlows.computeIfAbsent(codecFeature, __ -> AbstractFlow.getFlow(decodeFlowClasses, codecFeature));
    }

    public static AbstractFlow<CodecContext> getEncodeFlow(long codecFeature) {
        return encodeFlows.computeIfAbsent(codecFeature, __ -> AbstractFlow.getFlow(encodeFlowClasses, codecFeature));
    }

    public static synchronized AbstractFlow<ValidationContext> getValidateFlow() {
        if (validateFlow == null) {
            FieldFlow filedFlow = new FieldFlow();
            DecodeFormulaFlow decodeFormulaFlow = new DecodeFormulaFlow();
            EncodeFormulaFlow encodeFormulaFlow = new EncodeFormulaFlow();
            ArrayFlow arrayFlow = new ArrayFlow();
            TimestampFlow timestampFlow = new TimestampFlow();
            filedFlow.setNext(decodeFormulaFlow).setNext(encodeFormulaFlow).setNext(arrayFlow).setNext(timestampFlow);
            validateFlow = filedFlow;
        }
        return validateFlow;
    }

    protected static AbstractFlow getFlow(Class<? extends AbstractFlow>[] flowClasses, long codecFeature) {
        AbstractFlow[] array = (AbstractFlow[])Arrays.stream(flowClasses).map(c -> {
            try {
                return (AbstractFlow)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodeException(CodecError.FAIL_CREATING_DECODE_FLOW, (Throwable)e);
            }
        }).filter(f -> (f.getFlowCode() & codecFeature) == 0L).toArray(AbstractFlow[]::new);
        AbstractFlow flow = array[0];
        for (int i = 1; i < array.length; ++i) {
            flow.setNext(array[i]);
            flow = flow.next;
        }
        return array[0];
    }
}

