/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.validate;

import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.ValidationContext;

public class TimestampFlow
extends AbstractFlow<ValidationContext> {
    @Override
    public void process(ValidationContext context) {
        Annotation typeAnnotation = context.getTypeAnnotation();
        if (typeAnnotation instanceof TimestampType) {
            boolean condition2;
            ProtocolType protocolType = ((TimestampType)typeAnnotation).protocolType();
            TimeUnit unit = ((TimestampType)typeAnnotation).unit();
            boolean condition1 = protocolType == ProtocolType.UINTEGER32 && unit == TimeUnit.SECONDS;
            boolean bl = condition2 = protocolType == ProtocolType.LONG && unit == TimeUnit.MILLISECONDS;
            if (!condition1 && !condition2) {
                throw new DecodeException(CodecError.ILLEGAL_TIMESTAMP_PARAMETERS);
            }
        }
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 6L;
    }
}

