/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;

public class EncoderFactory {
    protected static ConcurrentHashMap<Class<? extends TypeEncoder>, TypeEncoder> encoders = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static Consumer<EncodeContext> getEncoder(Class<? extends TypeEncoder> clazz) {
        return encoders.computeIfAbsent(clazz, c -> {
            try {
                return (TypeEncoder)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new EncodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_ENCODER.getMessage(), c.getName()), (Throwable)e);
            }
        })::encode;
    }

    public static <T, R> Function<? super T, ? extends R> getFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, c -> {
            try {
                return (Function)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new EncodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_ENCODE_FORMULA.getMessage(), c.getName()), (Throwable)e);
            }
        });
    }
}

