/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.kafka;

import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.indunet.fastproto.FastProto;
import org.indunet.fastproto.kafka.ProtocolKafkaException;

public class ProtocolSerializer
implements Serializer<Object> {
    protected Class<?> clazz;
    protected int length;

    public void configure(Map<String, ?> props, boolean isKey) {
        block10: {
            if (!props.containsKey("protocol.class")) {
                throw new ProtocolKafkaException(ProtocolKafkaException.ProtoKafkaError.PROTOCOL_CLASS_NOT_FOUND);
            }
            if (!props.containsKey("datagram.length")) {
                throw new ProtocolKafkaException(ProtocolKafkaException.ProtoKafkaError.DATAGRAM_LENGTH_NOT_FOUND);
            }
            Object protocolClass = props.get("protocol.class");
            Object length = props.get("datagram.length");
            if (protocolClass instanceof Class) {
                this.clazz = (Class)protocolClass;
            } else if (protocolClass instanceof String) {
                this.clazz = Class.forName((String)protocolClass);
            } else {
                throw new ProtocolKafkaException(ProtocolKafkaException.ProtoKafkaError.INVALID_PROTOCOL_CLASS);
            }
            if (length instanceof String) {
                this.length = Integer.valueOf((String)length);
                break block10;
            }
            if (length instanceof Integer) {
                this.length = (Integer)length;
                break block10;
            }
            throw new ProtocolKafkaException(ProtocolKafkaException.ProtoKafkaError.INVALID_DATAGRAM_LENGTH);
        }
    }

    public byte[] serialize(String topic, Object object) {
        if (this.clazz.isInstance(object)) {
            return FastProto.toByteArray(object, this.length);
        }
        throw new ProtocolKafkaException(ProtocolKafkaException.ProtoKafkaError.TYPE_NOT_MATCH);
    }
}

