/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.DecoderFactory;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class DecodeFlow
extends AbstractFlow<CodecContext> {
    @Override
    public void process(CodecContext context) {
        TypeAssist assist = context.getTypeAssist();
        byte[] datagram = context.getDatagram();
        if (assist.getNoArgsConstructor().booleanValue()) {
            context.setObject(this.linearDecode(datagram, assist));
        } else {
            context.setObject(this.dfsDecode(datagram, assist));
        }
        this.nextFlow(context);
    }

    public Object linearDecode(byte[] datagram, TypeAssist assist) {
        List<DecodeContext> decodeContexts = assist.toDecodeContexts(datagram);
        Class<?> protocolClass = assist.getClazz();
        decodeContexts.forEach(c -> {
            TypeAssist a = c.getTypeAssist();
            Function<DecodeContext, ?> func = DecoderFactory.getDecoder(a.getDecoderClass(), a.getDecodeFormula());
            try {
                Object value = func.apply((DecodeContext)c);
                Object o = c.getObject();
                a.setValue(o, value);
            }
            catch (DecodingException e) {
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), a.getField().toString()), (Throwable)e);
            }
        });
        return assist.getObject(protocolClass);
    }

    public Object dfsDecode(byte[] datagram, TypeAssist assist) {
        Class[] classes = (Class[])Arrays.stream(assist.getClazz().getDeclaredFields()).map(Field::getType).toArray(Class[]::new);
        Class<?> clazz = assist.getClazz();
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            throw new DecodingException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), assist.getClazz().getName()), (Throwable)e);
        }
        Object[] objects = assist.getElements().stream().map(a -> {
            if (a.getElementType() == ElementType.FIELD) {
                Function<DecodeContext, ?> func = DecoderFactory.getDecoder(a.getDecoderClass(), a.getDecodeFormula());
                try {
                    return func.apply(a.toDecodeContext(datagram, null));
                }
                catch (DecodingException e) {
                    throw new DecodingException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), a.getField().toString()), (Throwable)e);
                }
            }
            if (assist.getCircularReference().booleanValue()) {
                return null;
            }
            return this.dfsDecode(datagram, (TypeAssist)a);
        }).toArray(Object[]::new);
        try {
            return constructor.newInstance(objects);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DecodingException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), assist.getClazz().getName()), (Throwable)e);
        }
    }

    @Override
    public long getFlowCode() {
        return 1L;
    }
}

