/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.lang.annotation.ElementType;
import java.util.ArrayDeque;
import org.indunet.fastproto.ProtocolVersionAssist;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.checksum.CheckerUtils;
import org.indunet.fastproto.exception.AddressingException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class InferLengthFlow
extends AbstractFlow<CodecContext> {
    @Override
    public void process(CodecContext context) {
        ArrayDeque<TypeAssist> queue = new ArrayDeque<TypeAssist>();
        int max = 0;
        queue.add(context.getTypeAssist());
        while (!queue.isEmpty()) {
            TypeAssist assist = (TypeAssist)queue.remove();
            assist.getElements().stream().filter(a -> a.getElementType() == ElementType.TYPE).forEach(a -> queue.add((TypeAssist)a));
            int length = assist.getElements().stream().filter(a -> a.getElementType() == ElementType.FIELD).mapToInt(a -> {
                if (a.getByteOffset() < 0 || a.getLength() < 0) {
                    throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
                }
                return a.getByteOffset() + a.getSize() + a.getLength();
            }).max().orElse(0);
            if (length <= max) continue;
            max = length;
        }
        if (max == 0) {
            throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
        }
        max += CheckerUtils.getSize(context.getProtocolClass());
        context.setDatagram(new byte[max += ProtocolVersionAssist.size(context.getTypeAssist())]);
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 4096L;
    }
}

