/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.graph.ReferenceResolver;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class FastProto {
    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> protocolClass) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        return FastProto.parseFrom(datagram, protocolClass, 0L);
    }

    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> protocolClass, long ... codecFeatures) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        ReferenceGraph graph = ReferenceResolver.resolve(protocolClass);
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().datagram(datagram).protocolClass(protocolClass).codecFeature(codecFeature).referenceGraph(graph).build();
        long feature = CodecFeature.of(graph.root());
        AbstractFlow.getDecodeFlow(feature | codecFeature).process(context);
        return context.getObject(protocolClass);
    }

    public static byte[] toByteArray(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, 0L);
    }

    public static byte[] toByteArray(@NonNull Object object, int length) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, length, 0L);
    }

    public static byte[] toByteArray(@NonNull Object object, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        ReferenceGraph graph = ReferenceResolver.resolve(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).referenceGraph(graph).build();
        long feature = CodecFeature.of(graph.root());
        AbstractFlow.getEncodeFlow(feature | codecFeature).process(context);
        return context.getDatagram();
    }

    public static byte[] toByteArray(@NonNull Object object, int length, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        ReferenceGraph graph = ReferenceResolver.resolve(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).datagram(new byte[length]).referenceGraph(graph).build();
        long feature = CodecFeature.of(graph.root());
        AbstractFlow.getEncodeFlow(feature | 0x1000L | codecFeature).process(context);
        return context.getDatagram();
    }
}

