/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.annotation.type.DateType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Integer16Type;
import org.indunet.fastproto.annotation.type.Integer8Type;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.annotation.type.ListType;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.annotation.type.UInteger16Type;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;

public enum ProtocolType {
    BINARY(BinaryType.class),
    BOOLEAN(BooleanType.class),
    CHARACTER(CharacterType.class),
    BYTE(ByteType.class),
    DOUBLE(DoubleType.class),
    FLOAT(FloatType.class),
    INTEGER(IntegerType.class),
    LONG(LongType.class),
    SHORT(ShortType.class),
    STRING(StringType.class),
    TIMESTAMP(TimestampType.class),
    DATE(DateType.class),
    INTEGER8(Integer8Type.class),
    INTEGER16(Integer16Type.class),
    UINTEGER8(UInteger8Type.class),
    UINTEGER16(UInteger16Type.class),
    UINTEGER32(UInteger32Type.class),
    UINTEGER64(UInteger64Type.class),
    ENUM(EnumType.class),
    LIST(ListType.class),
    ARRAY(ArrayType.class);

    Class<? extends Annotation> typeAnnotationClass;
    protected static final String SIZE_NAME = "SIZE";
    protected static final String PROTOCOL_TYPES_NAME = "PROTOCOL_TYPES";
    protected static final String JAVA_TYPES_NAME = "JAVA_TYPES";
    protected static final String AUTO_TYPE_NAME = "AUTO_TYPE";
    protected static final String BYTE_OFFSET_NAME = "value";
    protected static final String BIT_OFFSET_NAME = "bitOffset";
    protected static final String LENGTH_NAME = "length";
    protected static final String ENCODE_FORMULA_NAME = "encodingFormula";
    protected static final String DECODE_FORMULA_NAME = "decodingFormula";

    public boolean autoType() {
        Field field = this.typeAnnotationClass.getField(AUTO_TYPE_NAME);
        return field.getBoolean(null);
    }

    public Type javaType() {
        return this.javaTypes()[0];
    }

    public Type[] javaTypes() {
        Field field = this.typeAnnotationClass.getField(JAVA_TYPES_NAME);
        return (Type[])field.get(null);
    }

    public boolean match(Type type) {
        return Arrays.stream(this.javaTypes()).anyMatch(t -> t == type);
    }

    public static ProtocolType valueOf(Class<? extends Annotation> clazz) {
        return Arrays.stream(ProtocolType.values()).filter(t -> t.typeAnnotationClass == clazz).findFirst().orElseThrow(CodecException::new);
    }

    public static ProtocolType byAutoType(Type type) {
        return Arrays.stream(ProtocolType.values()).filter(t -> Arrays.asList(t.javaTypes()).contains(type)).findFirst().orElseThrow(CodecException::new);
    }

    public static Type[] supportedTypes() {
        return (Type[])Arrays.stream(ProtocolType.values()).map(ProtocolType::getTypeAnnotationClass).flatMap(c -> Arrays.stream(ProtocolType.javaTypes(c))).toArray(Type[]::new);
    }

    public static boolean isSupported(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Arrays.stream(ProtocolType.values()).map(ProtocolType::getTypeAnnotationClass).flatMap(c -> Arrays.stream(ProtocolType.javaTypes(c))).anyMatch(t -> t == type);
    }

    public static Type wrapperClass(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        switch (name) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        throw new CodecException(MessageFormat.format(CodecError.UNSUPPORTED_TYPE.getMessage(), name));
    }

    public static int size(@NonNull ProtocolType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return type.getTypeAnnotationClass().getDeclaredField(SIZE_NAME).getInt(null);
    }

    public static int size(@NonNull Class<? extends Annotation> typeAnnotationClass) {
        if (typeAnnotationClass == null) {
            throw new NullPointerException("typeAnnotationClass is marked non-null but is null");
        }
        return typeAnnotationClass.getDeclaredField(SIZE_NAME).getInt(null);
    }

    public static ProtocolType[] protocolTypes(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return (ProtocolType[])typeAnnotation.annotationType().getDeclaredField(PROTOCOL_TYPES_NAME).get(typeAnnotation);
    }

    public static Class<? extends Function> encodeFormula(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return ProtocolType.formula(typeAnnotation, ENCODE_FORMULA_NAME);
    }

    public static Class<? extends Function> decodeFormula(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return ProtocolType.formula(typeAnnotation, DECODE_FORMULA_NAME);
    }

    public static Class<? extends TypeDecoder> decoderCLass(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return Optional.of(typeAnnotation.annotationType()).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
    }

    public static Class<? extends TypeEncoder> encoderClass(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return Optional.of(typeAnnotation.annotationType()).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
    }

    protected static Class<? extends Function> formula(@NonNull Annotation typeAnnotation, @NonNull String name) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Method method = typeAnnotation.getClass().getMethod(name, new Class[0]);
        Object array = method.invoke((Object)typeAnnotation, new Object[0]);
        return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
    }

    public static Type[] javaTypes(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return (Type[])typeAnnotation.getClass().getField(JAVA_TYPES_NAME).get(null);
    }

    public static Type[] javaTypes(@NonNull Class<? extends Annotation> typeAnnotationClass) {
        if (typeAnnotationClass == null) {
            throw new NullPointerException("typeAnnotationClass is marked non-null but is null");
        }
        return (Type[])typeAnnotationClass.getDeclaredField(JAVA_TYPES_NAME).get(null);
    }

    public static int byteOffset(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return (Integer)typeAnnotation.getClass().getMethod(BYTE_OFFSET_NAME, new Class[0]).invoke((Object)typeAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    public static int bitOffset(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return (Integer)typeAnnotation.getClass().getMethod(BIT_OFFSET_NAME, new Class[0]).invoke((Object)typeAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    public static int size(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return typeAnnotation.getClass().getField(SIZE_NAME).getInt(typeAnnotation);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
    }

    public static int length(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return (Integer)typeAnnotation.getClass().getMethod(LENGTH_NAME, new Class[0]).invoke((Object)typeAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    private ProtocolType(Class<? extends Annotation> typeAnnotationClass) {
        this.typeAnnotationClass = typeAnnotationClass;
    }

    public Class<? extends Annotation> getTypeAnnotationClass() {
        return this.typeAnnotationClass;
    }
}

