/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.ProtocolVersionException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.util.CodecUtils;

public class ProtocolVersionAssist {
    public static boolean validate(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableProtocolVersion() == null) {
            return true;
        }
        EnableProtocolVersion enableProtocolVersion = reference.getEnableProtocolVersion();
        return enableProtocolVersion.version() == ProtocolVersionAssist.decode(datagram, reference);
    }

    public static int decode(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableProtocolVersion() == null) {
            return -1;
        }
        EnableProtocolVersion enableProtocolVersion = reference.getEnableProtocolVersion();
        EndianPolicy policy = ProtocolVersionAssist.endianPolicy(reference);
        int byteOffset = enableProtocolVersion.value();
        switch (enableProtocolVersion.protocolType()) {
            case UINTEGER8: {
                return CodecUtils.uinteger8Type(datagram, byteOffset);
            }
            case UINTEGER16: {
                return CodecUtils.uinteger16Type(datagram, byteOffset, policy);
            }
            case INTEGER: {
                return CodecUtils.integerType(datagram, byteOffset, policy);
            }
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }

    public static void encode(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableProtocolVersion() == null) {
            return;
        }
        EnableProtocolVersion versionAnnotation = reference.getEnableProtocolVersion();
        EndianPolicy policy = ProtocolVersionAssist.endianPolicy(reference);
        int byteOffset = versionAnnotation.value();
        int version = versionAnnotation.version();
        switch (versionAnnotation.protocolType()) {
            case UINTEGER8: {
                CodecUtils.uinteger8Type(datagram, byteOffset, version);
                break;
            }
            case UINTEGER16: {
                CodecUtils.uinteger16Type(datagram, byteOffset, policy, version);
                break;
            }
            case INTEGER: {
                CodecUtils.integerType(datagram, byteOffset, policy, version);
                break;
            }
            default: {
                throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
            }
        }
    }

    public static EndianPolicy endianPolicy(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        EnableProtocolVersion enableProtocolVersion = reference.getEnableProtocolVersion();
        if (enableProtocolVersion.endianPolicy().length > 0) {
            return enableProtocolVersion.endianPolicy()[0];
        }
        return reference.getEndianPolicy();
    }

    public static int size(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableProtocolVersion() == null) {
            return 0;
        }
        EnableProtocolVersion enableProtocolVersion = reference.getEnableProtocolVersion();
        switch (enableProtocolVersion.protocolType()) {
            case UINTEGER8: {
                return 1;
            }
            case UINTEGER16: {
                return 2;
            }
            case INTEGER: {
                return 4;
            }
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }
}

