/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ArrayDecoder
implements TypeDecoder<Object> {
    @Override
    public Object decode(DecodeContext context) {
        ArrayType type = context.getTypeAnnotation(ArrayType.class);
        int length = type.length();
        Class<?> componentType = context.getReference().getField().getType().getComponentType();
        return this.decode(context.getDatagram(), type.value(), length, type.protocolType(), context.getEndianPolicy(), componentType.isPrimitive());
    }

    public Object decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull ProtocolType type, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.decode(datagram, byteOffset, length, type, policy, false);
    }

    public Object decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull ProtocolType type, @NonNull EndianPolicy policy, boolean primitive) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.offset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new DecodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        ArrayList list = new ArrayList();
        Consumer<Function> codec = func -> IntStream.range(0, length).parallel().forEachOrdered(i -> list.add(func.apply(i * size + bo)));
        switch (type) {
            case CHARACTER: {
                codec.accept(b -> Character.valueOf(CodecUtils.characterType(datagram, b, policy)));
                return primitive ? TypeUtils.listToArray(list, new char[length]) : list.toArray(new Character[length]);
            }
            case BYTE: {
                codec.accept(b -> CodecUtils.byteType(datagram, b));
                return primitive ? TypeUtils.listToArray(list, new byte[length]) : list.toArray(new Byte[length]);
            }
            case SHORT: {
                codec.accept(b -> CodecUtils.shortType(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new short[length]) : list.toArray(new Short[length]);
            }
            case INTEGER: {
                codec.accept(b -> CodecUtils.integerType(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
            }
            case LONG: {
                codec.accept(b -> CodecUtils.longType(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new long[length]) : list.toArray(new Long[length]);
            }
            case UINTEGER8: {
                codec.accept(b -> CodecUtils.uinteger8Type(datagram, b));
                return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
            }
            case UINTEGER16: {
                codec.accept(b -> CodecUtils.uinteger16Type(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
            }
            case UINTEGER32: {
                codec.accept(b -> CodecUtils.uinteger32Type(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new long[length]) : list.toArray(new Long[length]);
            }
            case INTEGER8: {
                codec.accept(b -> CodecUtils.integer8Type(datagram, b));
                return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
            }
            case INTEGER16: {
                codec.accept(b -> CodecUtils.integer16Type(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new int[length]) : list.toArray(new Integer[length]);
            }
            case FLOAT: {
                codec.accept(b -> Float.valueOf(CodecUtils.floatType(datagram, b, policy)));
                return primitive ? TypeUtils.listToArray(list, new float[length]) : list.toArray(new Float[length]);
            }
            case DOUBLE: {
                codec.accept(b -> CodecUtils.doubleType(datagram, b, policy));
                return primitive ? TypeUtils.listToArray(list, new double[length]) : list.toArray(new Double[length]);
            }
        }
        throw new DecodingException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
    }
}

