/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ByteDecoder
implements TypeDecoder<Byte> {
    @Override
    public Byte decode(DecodeContext context) {
        ByteType type = context.getTypeAnnotation(ByteType.class);
        return this.decode(context.getDatagram(), type.value());
    }

    public byte decode(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            return CodecUtils.byteType(datagram, offset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the byte type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Fail decoding the byte type.", (Throwable)e);
        }
    }
}

