/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class EnumDecoder<T extends Enum>
implements TypeDecoder<T> {
    @Override
    public T decode(DecodeContext context) {
        EnumType type = context.getTypeAnnotation(EnumType.class);
        Class<?> enumClass = context.getReference().getField().getType();
        return (T)this.decode(context.getDatagram(), type.value(), context.getEndianPolicy(), type.protocolType(), type.fieldName(), enumClass);
    }

    public T decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, @NonNull ProtocolType type, @NonNull String fieldName, @NonNull Class<T> enumClass) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        int code = this.getCode(datagram, byteOffset, policy, type);
        if (fieldName.isEmpty()) {
            return (T)Arrays.stream(enums).filter(e -> e.ordinal() == code).findAny().orElseThrow(() -> new DecodingException(MessageFormat.format(CodecError.ENUM_NOT_FOUND.getMessage(), code)));
        }
        Function<Enum, Integer> getValue = enumObject -> {
            Field field = null;
            try {
                field = enumClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.getInt(enumObject);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new DecodingException(MessageFormat.format(CodecError.ILLEGAL_ENUM_CODE_FIELD.getMessage(), fieldName), (Throwable)e);
            }
        };
        return (T)Arrays.stream(enums).filter(e -> (Integer)getValue.apply((Enum)e) == code).findAny().orElseThrow(() -> new DecodingException(MessageFormat.format(CodecError.ENUM_NOT_FOUND.getMessage(), code)));
    }

    public int getCode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy policy, @NonNull ProtocolType type) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type == ProtocolType.UINTEGER8) {
            return CodecUtils.uinteger8Type(datagram, offset);
        }
        if (type == ProtocolType.UINTEGER16) {
            return CodecUtils.uinteger16Type(datagram, offset, policy);
        }
        if (type == ProtocolType.INTEGER) {
            return CodecUtils.integerType(datagram, offset, policy);
        }
        throw new DecodingException(CodecError.INVALID_ENUM_PROTOCOL_TYPE);
    }
}

