/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.math.BigInteger;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInteger64Decoder
implements TypeDecoder<BigInteger> {
    @Override
    public BigInteger decode(DecodeContext context) {
        UInteger64Type type = context.getTypeAnnotation(UInteger64Type.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public BigInteger decode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        try {
            return CodecUtils.uinteger64Type(datagram, offset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the uinteger64 type.", (Throwable)e);
        }
    }
}

