/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import lombok.NonNull;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.TypeFlag;
import org.indunet.fastproto.graph.AbstractFlow;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;

public class ReferenceResolver {
    protected static ConcurrentHashMap<Class<?>, ReferenceGraph> graphs = new ConcurrentHashMap();
    protected static AbstractFlow<Reference> resolveClassFlow = AbstractFlow.getResolveClassFlow();
    protected static AbstractFlow<Reference> resolveFieldFlow = AbstractFlow.getResolveFieldFlow();

    public static ReferenceGraph resolve(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        return graphs.computeIfAbsent(protocolClass, __ -> {
            ReferenceGraph graph = new ReferenceGraph();
            ArrayDeque deque = new ArrayDeque();
            Reference reference = Reference.builder().protocolClass(protocolClass).referenceType(Reference.ReferenceType.CLASS).build();
            resolveClassFlow.process(reference);
            graph.addClass(reference);
            Arrays.stream(protocolClass.getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(f -> deque.add(f));
            while (!deque.isEmpty()) {
                Reference s;
                Field field = (Field)deque.remove();
                if (ReferenceResolver.isData(field)) {
                    s = Reference.builder().field(field).referenceType(Reference.ReferenceType.FIELD).build();
                    resolveFieldFlow.process(s);
                    graph.addReference(s);
                    continue;
                }
                if (ReferenceResolver.isClass(field)) {
                    if (graph.contains(field.getType())) {
                        Reference ref = graph.getReference(field.getType()).withField(field);
                        graph.addReference(ref);
                        continue;
                    }
                    s = Reference.builder().protocolClass(field.getType()).field(field).referenceType(Reference.ReferenceType.CLASS).build();
                    resolveClassFlow.process(s);
                    graph.addClass(s);
                    graph.addReference(s);
                    Arrays.stream(field.getType().getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(f -> deque.add(f));
                    continue;
                }
                s = Reference.builder().field(field).referenceType(Reference.ReferenceType.INVALID).build();
                graph.addReference(s);
            }
            return graph;
        });
    }

    protected static boolean isClass(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Predicate<Field> isProtocolType = f -> ProtocolType.isSupported(f.getType());
        Predicate<Field> isTransient = f -> Modifier.isTransient(f.getModifiers());
        Predicate<Field> isEnum = f -> f.isEnumConstant() || Enum.class.isAssignableFrom(f.getType());
        Predicate<Field> isEnumSet = f -> EnumSet.class.isAssignableFrom(f.getType());
        Predicate<Field> isArray = f -> f.getType().isArray();
        Predicate<Field> isClass = f -> f.getType() == Class.class;
        Predicate<Field> isObject = f -> f.getType() == Object.class;
        Predicate<Field> isList = f -> List.class.isAssignableFrom(f.getType());
        Predicate<Field> isMap = f -> Map.class.isAssignableFrom(f.getType());
        Predicate<Field> isSet = f -> Set.class.isAssignableFrom(f.getType());
        return !isProtocolType.or(isTransient).or(isEnum).or(isEnumSet).or(isArray).or(isClass).or(isObject).or(isList).or(isMap).or(isSet).test(field);
    }

    protected static boolean isData(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Predicate<Field> isTypeFlag = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(TypeFlag.class));
        return isTypeFlag.test(field);
    }
}

