/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.function.Function;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.AbstractFlow;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.ValidationContext;

public class CodecFlow
extends AbstractFlow<Reference> {
    @Override
    public void process(Reference reference) {
        Annotation typeAnnotation = reference.getTypeAnnotation();
        Class<? extends TypeDecoder> decoderClass = ProtocolType.decoderCLass(typeAnnotation);
        Class<? extends TypeEncoder> encoderClass = ProtocolType.encoderClass(typeAnnotation);
        Class<? extends Function> afterDecode = ProtocolType.decodeFormula(typeAnnotation);
        Class<? extends Function> beforeEncode = ProtocolType.encodeFormula(typeAnnotation);
        reference.setDecoderClass(decoderClass);
        reference.setEncoderClass(encoderClass);
        reference.setDecodeFormula(afterDecode);
        reference.setEncodeFormula(beforeEncode);
        Field field = reference.getField();
        ValidationContext context = ValidationContext.builder().field(field).typeAnnotation(typeAnnotation).build();
        try {
            org.indunet.fastproto.pipeline.AbstractFlow.getValidateFlow().process(context);
        }
        catch (ResolveException e) {
            throw new ResolveException(MessageFormat.format("Fail resolving the filed of %s", field.toString()), (Throwable)e);
        }
        this.nextFlow(reference);
    }

    @Override
    public long getFlowCode() {
        return 0L;
    }
}

