/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.util.Arrays;
import org.indunet.fastproto.annotation.Constructor;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.AbstractFlow;
import org.indunet.fastproto.graph.Reference;

public class ConstructorFlow
extends AbstractFlow<Reference> {
    @Override
    public void process(Reference reference) {
        Class<?> protocolClass = reference.getProtocolClass();
        int cnt = 0;
        cnt = Arrays.stream(protocolClass.getConstructors()).anyMatch(c -> c.isAnnotationPresent(Constructor.class)) ? Arrays.stream(protocolClass.getConstructors()).filter(c -> c.isAnnotationPresent(Constructor.class)).findAny().get().getParameterCount() : Arrays.stream(protocolClass.getConstructors()).mapToInt(c -> c.getParameterCount()).min().getAsInt();
        if (cnt == 0) {
            reference.setConstructorType(Reference.ConstructorType.NO_ARGS);
        } else {
            if (protocolClass.getDeclaredFields().length != cnt) {
                throw new ResolveException(String.format("The number of constructor parameters of %s does not match the number of class fields.", protocolClass.getName()));
            }
            reference.setConstructorType(Reference.ConstructorType.ALL_ARGS);
        }
        this.nextFlow(reference);
    }

    @Override
    public long getFlowCode() {
        return 0L;
    }
}

