/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.reflect.Field;
import java.util.Optional;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.graph.AbstractFlow;
import org.indunet.fastproto.graph.Reference;

public class EndianFlow
extends AbstractFlow<Reference> {
    protected static final EndianPolicy DEFAULT_ENDIAN_POLICY = EndianPolicy.LITTLE;

    @Override
    public void process(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getReferenceType() == Reference.ReferenceType.CLASS) {
            Class<?> protocolClass = reference.getProtocolClass();
            EndianPolicy endianPolicy = Optional.ofNullable(protocolClass.getAnnotation(Endian.class)).map(Endian::value).orElse(DEFAULT_ENDIAN_POLICY);
            reference.setEndianPolicy(endianPolicy);
        } else if (reference.getReferenceType() == Reference.ReferenceType.FIELD) {
            Field field = reference.getField();
            EndianPolicy endianPolicy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElseGet(() -> Optional.ofNullable(reference.getField().getDeclaringClass()).map(c -> c.getAnnotation(Endian.class)).map(Endian::value).orElse(DEFAULT_ENDIAN_POLICY));
            reference.setEndianPolicy(endianPolicy);
        }
        this.nextFlow(reference);
    }

    @Override
    public long getFlowCode() {
        return 0L;
    }
}

