/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.TypeFlag;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.AbstractFlow;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.util.TypeUtils;

public class TypeAnnotationFlow
extends AbstractFlow<Reference> {
    @Override
    public void process(Reference reference) {
        Field field = reference.getField();
        Annotation typeAnnotation = Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(TypeFlag.class)).findAny().orElseThrow(ResolveException::new);
        reference.setTypeAnnotation(typeAnnotation);
        reference.setReferenceType(Reference.ReferenceType.FIELD);
        reference.setDecoderClass(ProtocolType.decoderCLass(typeAnnotation));
        reference.setEncoderClass(ProtocolType.encoderClass(typeAnnotation));
        reference.setDecodeFormula(TypeUtils.decodingFormula(typeAnnotation));
        reference.setEncodeFormula(TypeUtils.encodingFormula(typeAnnotation));
        this.nextFlow(reference);
    }

    @Override
    public long getFlowCode() {
        return 0L;
    }
}

