/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.indunet.fastproto.FastProto;

public class ProtocolCodec
extends ByteToMessageCodec {
    Class<?> protocolClass;
    Optional<Integer> length;

    public ProtocolCodec(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        this.protocolClass = protocolClass;
        this.length = Optional.empty();
    }

    public ProtocolCodec(@NonNull Class<?> protocolClass, int length) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        this.protocolClass = protocolClass;
        this.length = Optional.of(length);
    }

    protected void encode(ChannelHandlerContext context, Object object, ByteBuf byteBuf) throws Exception {
        byte[] bytes = this.length.isPresent() ? FastProto.toByteArray(object) : FastProto.toByteArray(object);
        byteBuf.writeBytes(bytes);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf byteBuf, List list) throws Exception {
        int cnt = byteBuf.readableBytes();
        if (cnt <= 0) {
            return;
        }
        byte[] datagram = new byte[cnt];
        byteBuf.readBytes(datagram);
        Object object = FastProto.parseFrom(datagram, this.protocolClass);
        list.add(object);
    }
}

