/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.util.Optional;
import java.util.function.Supplier;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.crypto.Crypto;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CryptoException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class DecryptFlow
extends AbstractFlow<CodecContext> {
    @Override
    public void process(CodecContext context) {
        byte[] key;
        ReferenceGraph graph = context.getReferenceGraph();
        Reference ref = graph.root();
        if (ref.getEnableCrypto() == null) {
            return;
        }
        byte[] datagram = context.getDatagram();
        Crypto crypto = Crypto.getInstance(ref.getEnableCrypto());
        EnableCrypto enableCrypto = ref.getEnableCrypto();
        if (!enableCrypto.key().isEmpty()) {
            key = enableCrypto.key().getBytes();
        } else if (enableCrypto.keySupplier().length != 0) {
            key = Optional.of(enableCrypto).map(EnableCrypto::keySupplier).map(a -> {
                try {
                    Class c = a[0];
                    return (byte[])((Supplier)c.newInstance()).get();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CryptoException(CodecError.INVALID_CRYPTO_KEY_SUPPLIER, (Throwable)e);
                }
            }).get();
        } else {
            throw new CryptoException(CodecError.NO_CRYPTO_KEY);
        }
        context.setDatagram(crypto.decrypt(key, datagram));
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 2L;
    }
}

