/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.lang.annotation.Annotation;
import org.indunet.fastproto.ProtocolVersionAssist;
import org.indunet.fastproto.checksum.CheckerUtils;
import org.indunet.fastproto.exception.AddressingException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.util.TypeUtils;

public class InferLengthFlow
extends AbstractFlow<CodecContext> {
    @Override
    public void process(CodecContext context) {
        ReferenceGraph graph = context.getReferenceGraph();
        int max = graph.stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.FIELD).mapToInt(r -> {
            Annotation type = r.getTypeAnnotation();
            if (TypeUtils.byteOffset(type) < 0 || TypeUtils.length(type) < 0) {
                throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
            }
            return TypeUtils.byteOffset(type) + TypeUtils.size(type) + TypeUtils.length(type);
        }).max().orElse(0);
        if (max == 0) {
            throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
        }
        max += CheckerUtils.getSize(context.getProtocolClass());
        context.setDatagram(new byte[max += ProtocolVersionAssist.size(graph.root())]);
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 4096L;
    }
}

