/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.ValidationContext;
import org.indunet.fastproto.util.TypeUtils;

public class DecodeFormulaFlow
extends AbstractFlow<ValidationContext> {
    @Override
    public void process(ValidationContext context) {
        Class<? extends Function> decodeFormula = context.getDecodeFormula();
        Annotation typeAnnotation = context.getTypeAnnotation();
        Field field = context.getField();
        if (decodeFormula != null) {
            Arrays.stream(decodeFormula.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).filter(t -> {
                if (field.getType().isPrimitive()) {
                    return t == TypeUtils.wrapperClass(field.getType().getName());
                }
                if (field.getType().isEnum()) {
                    return ((Class)t).isAssignableFrom(field.getType());
                }
                return t == field.getType();
            }).findAny().orElseThrow(() -> new DecodeFormulaException(MessageFormat.format(CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
        }
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 2L;
    }
}

