/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class FloatDecoder
implements TypeDecoder<Float> {
    @Override
    public Float decode(DecodeContext context) {
        FloatType type = context.getTypeAnnotation(FloatType.class);
        return Float.valueOf(this.decode(context.getDatagram(), type.value(), context.getEndianPolicy()));
    }

    public float decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        try {
            return CodecUtils.floatType(datagram, byteOffset, endian);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the float type.", (Throwable)e);
        }
    }
}

