/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.nio.charset.Charset;
import lombok.NonNull;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class StringDecoder
implements TypeDecoder<String> {
    @Override
    public String decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        StringType type = context.getTypeAnnotation(StringType.class);
        return this.decode(context.getDatagram(), type.value(), type.length(), Charset.forName(type.charset()));
    }

    public String decode(@NonNull byte[] datagram, int offset, int length, @NonNull Charset charset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        try {
            byte[] bytes = CodecUtils.binaryType(datagram, offset, length);
            return new String(bytes, charset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the string type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Fail decoding the string type.", (Throwable)e);
        }
    }
}

