/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class EnumEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EnumType type = context.getTypeAnnotation(EnumType.class);
        Enum value = context.getValue(Enum.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), type.genericType(), type.field(), value);
    }

    public <T extends Enum> void encode(@NonNull byte[] datagram, int offset, EndianPolicy policy, @NonNull Class<? extends Annotation> type, @NonNull String fieldName, @NonNull T value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int code = 0;
        if (fieldName == null || fieldName.isEmpty()) {
            code = value.ordinal();
        } else {
            try {
                Field field = value.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                code = field.getInt(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new EncodingException(MessageFormat.format(CodecError.ILLEGAL_ENUM_CODE_FIELD.getMessage(), fieldName), (Throwable)e);
            }
        }
        if (type == ProtocolType.UINTEGER8) {
            CodecUtils.uinteger8Type(datagram, offset, code);
        } else if (type == ProtocolType.UINTEGER16) {
            CodecUtils.uinteger16Type(datagram, offset, policy, code);
        } else if (type == ProtocolType.INTEGER) {
            CodecUtils.integerType(datagram, offset, policy, code);
        } else {
            throw new EncodingException(CodecError.INVALID_ENUM_PROTOCOL_TYPE);
        }
    }
}

