/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.annotation.type.Integer8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Integer8Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        Integer8Type type = context.getTypeAnnotation(Integer8Type.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), value);
    }

    public void encode(byte[] datagram, int offset, int value) {
        try {
            CodecUtils.integer8Type(datagram, offset, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the integer8 type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the integer8 type.", (Throwable)e);
        }
    }
}

