/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.math.BigInteger;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInteger64Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        UInteger64Type type = context.getTypeAnnotation(UInteger64Type.class);
        BigInteger value = context.getValue(BigInteger.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int offset, @NonNull EndianPolicy policy, BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        try {
            CodecUtils.uinteger64Type(datagram, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the uinteger64 type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException("Fail encoding the uinteger64 type.", (Throwable)e);
        }
    }
}

