/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.function.Function;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.validate.TypeValidator;
import org.indunet.fastproto.graph.validate.ValidatorContext;
import org.indunet.fastproto.util.TypeUtils;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Annotation typeAnnotation = reference.getTypeAnnotation();
        Class<? extends TypeDecoder> decoderClass = TypeUtils.decoderClass(typeAnnotation);
        Class<? extends TypeEncoder> encoderClass = TypeUtils.encoderClass(typeAnnotation);
        Class<? extends Function> afterDecode = TypeUtils.decodingFormula(typeAnnotation);
        Class<? extends Function> beforeEncode = TypeUtils.encodingFormula(typeAnnotation);
        reference.setDecoderClass(decoderClass);
        reference.setEncoderClass(encoderClass);
        reference.setDecodeFormula(afterDecode);
        reference.setEncodeFormula(beforeEncode);
        Field field = reference.getField();
        ValidatorContext context = ValidatorContext.builder().field(field).typeAnnotation(typeAnnotation).protocolType(reference.getProtocolType()).build();
        try {
            Validator validator = typeAnnotation.annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(context);
        }
        catch (ResolveException e) {
            throw new ResolveException(MessageFormat.format("Fail resolving the filed of %s", field.toString()), (Throwable)e);
        }
        this.forward(reference);
    }
}

