/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Optional;
import org.indunet.fastproto.FastProto;
import org.indunet.fastproto.netty.ProtocolNettyException;

public class ProtocolEncoder
extends MessageToByteEncoder<Object> {
    Optional<Integer> length;

    public ProtocolEncoder() {
        this.length = Optional.empty();
    }

    public ProtocolEncoder(int length) {
        if (length <= 0) {
            throw new ProtocolNettyException(ProtocolNettyException.ProtoNettyError.ILLEAL_LENGTH);
        }
        this.length = Optional.of(length);
    }

    protected void encode(ChannelHandlerContext context, Object object, ByteBuf byteBuf) throws Exception {
        byte[] bytes = this.length.isPresent() ? FastProto.toByteArray(object, this.length.get()) : FastProto.toByteArray(object);
        byteBuf.writeBytes(bytes);
    }
}

