/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Function;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.DecoderFactory;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;

public class DecodeFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        Reference reference = context.getReferenceGraph().root();
        byte[] datagram = context.getDatagram();
        context.setObject(this.linearDecode(datagram, context.getReferenceGraph()));
        this.forward(context);
    }

    public Object linearDecode(byte[] datagram, ReferenceGraph graph) {
        List<DecodeContext> decodeContexts = graph.decodeContexts(datagram);
        decodeContexts.forEach(c -> {
            Reference r = c.getReference();
            Function<DecodeContext, ?> func = DecoderFactory.getDecoder(r.getDecoderClass(), r.getDecodeFormula());
            try {
                Object value = func.apply((DecodeContext)c);
                r.setValue(value);
            }
            catch (DecodingException e) {
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), r.getField().toString()), (Throwable)e);
            }
        });
        return graph.generate();
    }

    @Override
    public long getCode() {
        return 1L;
    }
}

