/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;

public class UncompressFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        boolean enableCompress = (context.getCodecFeature() & 0x104L) == 0L;
        Class<?> protocolClass = context.getProtocolClass();
        byte[] datagram = context.getDatagram();
        if (enableCompress && protocolClass.isAnnotationPresent(EnableCompress.class)) {
            EnableCompress annotation = protocolClass.getAnnotation(EnableCompress.class);
            Compressor compressor = Compressor.getInstance(annotation);
            context.setDatagram(compressor.uncompress(datagram));
        }
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 4L;
    }
}

