/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.text.MessageFormat;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.FixedLengthException;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;

public class VerifyFixedLengthFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        int length;
        int fixedLength = context.getReferenceGraph().root().getEnableFixedLength().value();
        if (fixedLength != (length = context.getDatagram().length)) {
            throw new FixedLengthException(MessageFormat.format(CodecError.FIXED_LENGTH_UNMATCH.getMessage(), fixedLength, length));
        }
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 32L;
    }
}

