/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.checksum.CheckerUtils;
import org.indunet.fastproto.exception.AddressingException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.ReferenceGraph;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.util.VersionUtils;

public class InferLengthFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        ReferenceGraph graph = context.getReferenceGraph();
        int max = graph.stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.FIELD).mapToInt(r -> {
            ProtocolType type = r.getProtocolType();
            if (type.value() < 0 || type.length() < 0) {
                throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
            }
            return type.value() + type.size() + type.length();
        }).max().orElse(0);
        if (max == 0) {
            throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
        }
        max += CheckerUtils.getSize(context.getProtocolClass());
        context.setDatagram(new byte[max += VersionUtils.size(graph.root())]);
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 4096L;
    }
}

