/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.annotation.type.EnumType;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.annotation.type.Integer16Type;
import org.indunet.fastproto.annotation.type.Integer8Type;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.annotation.type.ListType;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.annotation.type.UInteger16Type;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.util.TypeUtils;

public interface ProtocolType {
    public static final Class<? extends Annotation> BINARY = BinaryType.class;
    public static final Class<? extends Annotation> BOOLEAN = BooleanType.class;
    public static final Class<? extends Annotation> CHARACTER = CharacterType.class;
    public static final Class<? extends Annotation> BYTE = ByteType.class;
    public static final Class<? extends Annotation> DOUBLE = DoubleType.class;
    public static final Class<? extends Annotation> FLOAT = FloatType.class;
    public static final Class<? extends Annotation> INTEGER = IntegerType.class;
    public static final Class<? extends Annotation> LONG = LongType.class;
    public static final Class<? extends Annotation> SHORT = ShortType.class;
    public static final Class<? extends Annotation> STRING = StringType.class;
    public static final Class<? extends Annotation> TIMESTAMP = TimestampType.class;
    public static final Class<? extends Annotation> INTEGER8 = Integer8Type.class;
    public static final Class<? extends Annotation> INTEGER16 = Integer16Type.class;
    public static final Class<? extends Annotation> UINTEGER8 = UInteger8Type.class;
    public static final Class<? extends Annotation> UINTEGER16 = UInteger16Type.class;
    public static final Class<? extends Annotation> UINTEGER32 = UInteger32Type.class;
    public static final Class<? extends Annotation> UINTEGER64 = UInteger64Type.class;
    public static final Class<? extends Annotation> ENUM = EnumType.class;
    public static final Class<? extends Annotation> LIST = ListType.class;
    public static final Class<? extends Annotation> ARRAY = ArrayType.class;

    public static boolean isSupported(Type type) {
        return Arrays.stream(ProtocolType.class.getDeclaredFields()).filter(f -> f.getType() != boolean[].class).map(f -> {
            try {
                return (Class)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ResolveException("Fail getting protocol type.", (Throwable)e);
            }
        }).flatMap(t -> Arrays.stream(TypeUtils.javaTypes(t))).anyMatch(t -> t == type);
    }

    public static ProtocolType proxy(Annotation typeAnnotation) {
        return (ProtocolType)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{ProtocolType.class, typeAnnotation.annotationType()}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "getType": {
                    return typeAnnotation.annotationType();
                }
                case "javaTypes": {
                    return typeAnnotation.annotationType().getDeclaredField("ALLOWED_JAVA_TYPES").get(null);
                }
                case "size": {
                    try {
                        return typeAnnotation.annotationType().getDeclaredField("SIZE").getInt(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return 0;
                    }
                }
                case "length": {
                    if (Arrays.stream(typeAnnotation.getClass().getMethods()).anyMatch(m -> m.getName().equals("length"))) break;
                    return 0;
                }
            }
            return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get().invoke((Object)typeAnnotation, args);
        });
    }

    public int value();

    public int byteOffset();

    public int bitOffset();

    public int length();

    public Class<? extends Function<?, ?>>[] decodingFormula();

    public Class<? extends Function<?, ?>>[] encodingFormula();

    public String description();

    public String field();

    public EndianPolicy[] endianPolicy();

    public Class<? extends Annotation> getType();

    public Type[] javaTypes();

    public int size();
}

