/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import java.util.zip.CRC32;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.checksum.Checker;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class Crc32Checker
implements Checker {
    protected static final Crc32Checker checker = new Crc32Checker();

    public static Crc32Checker getInstance() {
        return checker;
    }

    @Override
    public boolean validate(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return true;
        }
        EnableChecksum checksum = protocolClass.getAnnotation(EnableChecksum.class);
        EndianPolicy policy = checksum.endianPolicy().length != 0 ? checksum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        long actual = this.getValue(datagram, checksum.start(), checksum.length());
        long expected = CodecUtils.uinteger32Type(datagram, ReverseUtils.offset(datagram.length, checksum.value()), policy);
        return actual == expected;
    }

    public long getValue(byte[] datagram, int start, int length) {
        int s = ReverseUtils.offset(datagram.length, start);
        int l = ReverseUtils.length(datagram.length, start, length);
        if (s < 0) {
            throw new DecodingException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new DecodingException(CodecError.ILLEGAL_PARAMETER);
        }
        if (s + length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        CRC32 crc32 = new CRC32();
        crc32.update(datagram, s, l);
        return crc32.getValue();
    }

    @Override
    public void setValue(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return;
        }
        EnableChecksum checkSum = protocolClass.getAnnotation(EnableChecksum.class);
        int byteOffset = checkSum.value();
        int start = checkSum.start();
        int length = checkSum.length();
        EndianPolicy policy = checkSum.endianPolicy().length != 0 ? checkSum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        this.setValue(datagram, byteOffset, start, length, policy);
    }

    @Override
    public int getSize() {
        return 4;
    }

    public void setValue(byte[] datagram, int byteOffset, int start, int length, EndianPolicy policy) {
        long value = this.getValue(datagram, start, length);
        CodecUtils.uinteger32Type(datagram, ReverseUtils.offset(datagram.length, byteOffset), policy, value);
    }
}

