/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BooleanDecoder
implements TypeDecoder<Boolean> {
    @Override
    public Boolean decode(DecodeContext context) {
        BooleanType type = context.getTypeAnnotation(BooleanType.class);
        return this.decode(context.getDatagram(), type.value(), type.bitOffset());
    }

    public boolean decode(@NonNull byte[] datagram, int byteOffset, int bitOffset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        try {
            return CodecUtils.booleanType(datagram, byteOffset, bitOffset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding the boolean type.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Fail decoding the boolean type.", (Throwable)e);
        }
    }
}

