/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.checksum.Checker;
import org.indunet.fastproto.exception.CheckSumException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.Pipeline;

public class VerifyChecksumFlow
extends Pipeline<CodecContext> {
    @Override
    public void process(CodecContext context) {
        Checker checker;
        Class<?> protocolClass = context.getProtocolClass();
        byte[] datagram = context.getDatagram();
        if (protocolClass.isAnnotationPresent(EnableChecksum.class) && !(checker = Checker.getInstance(protocolClass.getAnnotation(EnableChecksum.class))).validate(datagram, protocolClass)) {
            throw new CheckSumException(CodecError.ILLEGAL_CHECK_SUM);
        }
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 8L;
    }
}

