/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.lang.annotation.Annotation;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.EnableVersion;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.ProtocolVersionException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.util.CodecUtils;

public class VersionUtils {
    public static boolean validate(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableVersion() == null) {
            return true;
        }
        EnableVersion enableVersion = reference.getEnableVersion();
        return enableVersion.version() == VersionUtils.decode(datagram, reference);
    }

    public static int decode(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableVersion() == null) {
            return -1;
        }
        EnableVersion enableVersion = reference.getEnableVersion();
        EndianPolicy policy = VersionUtils.endianPolicy(reference);
        int byteOffset = enableVersion.value();
        Class<? extends Annotation> type = enableVersion.genericType();
        if (type == ProtocolType.UINTEGER8) {
            return CodecUtils.uinteger8Type(datagram, byteOffset);
        }
        if (type == ProtocolType.UINTEGER16) {
            return CodecUtils.uinteger16Type(datagram, byteOffset, policy);
        }
        if (type == ProtocolType.INTEGER) {
            return CodecUtils.integerType(datagram, byteOffset, policy);
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }

    public static void encode(@NonNull byte[] datagram, @NonNull Reference reference) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableVersion() == null) {
            return;
        }
        EnableVersion enableVersion = reference.getEnableVersion();
        EndianPolicy policy = VersionUtils.endianPolicy(reference);
        int byteOffset = enableVersion.value();
        int version = enableVersion.version();
        Class<? extends Annotation> type = enableVersion.genericType();
        if (type == ProtocolType.UINTEGER8) {
            CodecUtils.uinteger8Type(datagram, byteOffset, version);
        } else if (type == ProtocolType.UINTEGER16) {
            CodecUtils.uinteger16Type(datagram, byteOffset, policy, version);
        } else if (type == ProtocolType.INTEGER) {
            CodecUtils.integerType(datagram, byteOffset, policy, version);
        } else {
            throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
        }
    }

    public static EndianPolicy endianPolicy(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        EnableVersion enableProtocolVersion = reference.getEnableVersion();
        if (enableProtocolVersion.endianPolicy().length > 0) {
            return enableProtocolVersion.endianPolicy()[0];
        }
        return reference.getEndianPolicy();
    }

    public static int size(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getEnableVersion() == null) {
            return 0;
        }
        Class<? extends Annotation> type = reference.getEnableVersion().genericType();
        if (type == ProtocolType.UINTEGER8) {
            return 1;
        }
        if (type == ProtocolType.UINTEGER16) {
            return 2;
        }
        if (type == ProtocolType.INTEGER) {
            return 4;
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }
}

