/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public Byte decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
            return inputStream.readByte(type.offset());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int8(byte) type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Byte value) {
        try {
            Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
            outputStream.writeByte(type.offset(), value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int8(byte) type.", e);
        }
    }
}

