/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class DateCodec
implements Codec<Date> {
    @Override
    public Date decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            TimeType type = context.getDataTypeAnnotation(TimeType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            long millis = inputStream.readInt64(type.offset(), order);
            return new Date(millis);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Date value) {
        try {
            TimeType type = context.getDataTypeAnnotation(TimeType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            long millis = value.getTime();
            outputStream.writeInt64(type.offset(), order, millis);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time type.", e);
        }
    }

    public class LocalDateTimeCodec
    implements Codec<LocalDateTime> {
        @Override
        public LocalDateTime decode(CodecContext context, ByteBufferInputStream inputStream) {
            Date date = DateCodec.this.decode(context, inputStream);
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, LocalDateTime value) {
            Date date = Date.from(value.atZone(ZoneId.systemDefault()).toInstant());
            DateCodec.this.encode(context, outputStream, date);
        }
    }

    public class InstantCodec
    implements Codec<Instant> {
        @Override
        public Instant decode(CodecContext context, ByteBufferInputStream inputStream) {
            Date date = DateCodec.this.decode(context, inputStream);
            return Instant.ofEpochMilli(date.getTime());
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Instant value) {
            DateCodec.this.encode(context, outputStream, Date.from(value));
        }
    }

    public class CalendarCodec
    implements Codec<Calendar> {
        @Override
        public Calendar decode(CodecContext context, ByteBufferInputStream inputStream) {
            Date date = DateCodec.this.decode(context, inputStream);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Calendar calendar) {
            DateCodec.this.encode(context, outputStream, calendar.getTime());
        }
    }

    public class TimestampCodec
    implements Codec<Timestamp> {
        @Override
        public Timestamp decode(CodecContext context, ByteBufferInputStream inputStream) {
            Date date = DateCodec.this.decode(context, inputStream);
            return new Timestamp(date.getTime());
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Timestamp value) {
            DateCodec.this.encode(context, outputStream, value);
        }
    }
}

