/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.AutoType;
import org.indunet.fastproto.annotation.DataType;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.mapper.AnnotationMapper;

public class TypeAnnotationFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        Field field = reference.getField();
        Annotation typeAnnotation = Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(DataType.class)).findAny().orElseThrow(ResolveException::new);
        if (typeAnnotation instanceof AutoType) {
            Class<? extends Annotation> type = AnnotationMapper.get(field.getGenericType());
            Annotation proxy = ProtocolType.proxy((AutoType)typeAnnotation, type);
            reference.setDataTypeAnnotation(proxy);
            reference.setProtocolType(ProtocolType.proxy(proxy));
        } else {
            reference.setDataTypeAnnotation(typeAnnotation);
            reference.setProtocolType(ProtocolType.proxy(typeAnnotation));
        }
        reference.setReferenceType(Reference.ReferenceType.FIELD);
        this.forward(reference);
    }
}

