/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.io;

import java.math.BigInteger;
import java.util.stream.IntStream;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.io.ByteBuffer;

public final class ByteBufferOutputStream {
    ByteBuffer byteBuffer;
    int byteIndex;
    int bitIndex;

    public ByteBufferOutputStream() {
        this(new ByteBuffer());
    }

    public ByteBufferOutputStream(byte[] bytes) {
        this(new ByteBuffer(bytes));
    }

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        this.byteIndex = 0;
        this.bitIndex = 0;
    }

    public void writeBool(BitOrder order, boolean value) {
        this.writeBool(this.byteIndex, this.bitIndex, order, value);
    }

    public void writeBool(int byteOffset, int bitOffset, BitOrder order, boolean value) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int bo = bitOffset;
        if (order == BitOrder.MSB_0) {
            bo = 7 - bitOffset;
        }
        if (bo == 7) {
            ++this.byteIndex;
            this.bitIndex = 0;
        }
        if (value) {
            this.byteBuffer.orEq(byteOffset, (byte)(1 << bo));
        } else {
            this.byteBuffer.andEq(byteOffset, (byte)(~(1 << bo)));
        }
    }

    public void writeByte(byte value) {
        this.byteBuffer.set(this.byteIndex++, value);
    }

    public void writeByte(int offset, byte value) {
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        this.byteBuffer.set(offset, value);
    }

    public void writeShort(ByteOrder order, short value) {
        this.writeShort(this.byteIndex, order, value);
    }

    public void writeShort(int offset, ByteOrder order, short value) {
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 2;
        if (order == ByteOrder.LITTLE) {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
        } else if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 1, (byte)value);
            this.byteBuffer.set(o, (byte)(value >>> 8));
        }
    }

    public void writeInt8(int value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        this.byteBuffer.set(this.byteIndex++, (byte)value);
    }

    public void writeInt8(int offset, int value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        this.byteBuffer.set(offset, (byte)value);
    }

    public void writeInt16(ByteOrder order, int value) {
        this.writeInt16(this.byteIndex, order, value);
    }

    public void writeInt16(int offset, ByteOrder order, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Out of int16 range.");
        }
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 2;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 1, (byte)value);
            this.byteBuffer.set(o, (byte)(value >>> 8));
        } else {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
        }
    }

    public void writeInt32(ByteOrder order, int value) {
        this.writeInt32(this.byteIndex, order, value);
    }

    public void writeInt32(int offset, ByteOrder order, int value) {
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 4;
        if (order == ByteOrder.LITTLE) {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
            this.byteBuffer.set(o + 2, (byte)(value >>> 16));
            this.byteBuffer.set(o + 3, (byte)(value >>> 24));
        } else if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 3, (byte)value);
            this.byteBuffer.set(o + 2, (byte)(value >>> 8));
            this.byteBuffer.set(o + 1, (byte)(value >>> 16));
            this.byteBuffer.set(o, (byte)(value >>> 24));
        }
    }

    public void writeInt64(ByteOrder order, long value) {
        this.writeInt64(this.byteIndex, order, value);
    }

    public void writeInt64(int offset, ByteOrder order, long value) {
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 8;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 7, (byte)value);
            this.byteBuffer.set(o + 6, (byte)(value >>> 8));
            this.byteBuffer.set(o + 5, (byte)(value >>> 16));
            this.byteBuffer.set(o + 4, (byte)(value >>> 24));
            this.byteBuffer.set(o + 3, (byte)(value >>> 32));
            this.byteBuffer.set(o + 2, (byte)(value >>> 40));
            this.byteBuffer.set(o + 1, (byte)(value >>> 48));
            this.byteBuffer.set(o, (byte)(value >>> 56));
        } else {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
            this.byteBuffer.set(o + 2, (byte)(value >>> 16));
            this.byteBuffer.set(o + 3, (byte)(value >>> 24));
            this.byteBuffer.set(o + 4, (byte)(value >>> 32));
            this.byteBuffer.set(o + 5, (byte)(value >>> 40));
            this.byteBuffer.set(o + 6, (byte)(value >>> 48));
            this.byteBuffer.set(o + 7, (byte)(value >>> 56));
        }
    }

    public void writeUInt8(int value) {
        this.writeUInt8(this.byteIndex, value);
    }

    public void writeUInt8(int offset, int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Out of uint8 range.");
        }
        this.byteIndex = this.byteBuffer.reverse(offset) + 1;
        this.byteBuffer.set(offset, (byte)value);
    }

    public void writeUInt16(ByteOrder order, int value) {
        this.writeUInt16(this.byteIndex, order, value);
    }

    public void writeUInt16(int offset, ByteOrder order, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Out of uint16 range.");
        }
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 2;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 1, (byte)value);
            this.byteBuffer.set(o, (byte)(value >>> 8));
        } else {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
        }
    }

    public void writeUInt32(ByteOrder order, long value) {
        this.writeUInt32(this.byteIndex, order, value);
    }

    public void writeUInt32(int offset, ByteOrder order, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Out of uint32 range.");
        }
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + 4;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 3, (byte)value);
            this.byteBuffer.set(o + 2, (byte)(value >>> 8));
            this.byteBuffer.set(o + 1, (byte)(value >>> 16));
            this.byteBuffer.set(o, (byte)(value >>> 24));
        } else {
            this.byteBuffer.set(o, (byte)value);
            this.byteBuffer.set(o + 1, (byte)(value >>> 8));
            this.byteBuffer.set(o + 2, (byte)(value >>> 16));
            this.byteBuffer.set(o + 3, (byte)(value >>> 24));
        }
    }

    public void writeUInt64(ByteOrder order, BigInteger value) {
        this.writeUInt64(this.byteIndex, order, value);
    }

    public void writeUInt64(int offset, ByteOrder order, BigInteger value) {
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Out of uinteger64 range.");
        }
        int o = this.byteBuffer.reverse(offset);
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        this.byteIndex = o + 8;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 7, (byte)low);
            this.byteBuffer.set(o + 6, (byte)(low >>> 8));
            this.byteBuffer.set(o + 5, (byte)(low >>> 16));
            this.byteBuffer.set(o + 4, (byte)(low >>> 24));
            this.byteBuffer.set(o + 3, (byte)high);
            this.byteBuffer.set(o + 2, (byte)(high >>> 8));
            this.byteBuffer.set(o + 1, (byte)(high >>> 16));
            this.byteBuffer.set(o, (byte)(high >>> 24));
        } else {
            this.byteBuffer.set(o, (byte)low);
            this.byteBuffer.set(o + 1, (byte)(low >>> 8));
            this.byteBuffer.set(o + 2, (byte)(low >>> 16));
            this.byteBuffer.set(o + 3, (byte)(low >>> 24));
            this.byteBuffer.set(o + 4, (byte)high);
            this.byteBuffer.set(o + 5, (byte)(high >>> 8));
            this.byteBuffer.set(o + 6, (byte)(high >>> 16));
            this.byteBuffer.set(o + 7, (byte)(high >>> 24));
        }
    }

    public void writeFloat(ByteOrder order, float value) {
        this.writeFloat(this.byteIndex, order, value);
    }

    public void writeFloat(int offset, ByteOrder order, float value) {
        int o = this.byteBuffer.reverse(offset);
        int bits = Float.floatToIntBits(value);
        this.byteIndex = o + 4;
        if (order == ByteOrder.LITTLE) {
            this.byteBuffer.set(o, (byte)bits);
            this.byteBuffer.set(o + 1, (byte)(bits >>> 8));
            this.byteBuffer.set(o + 2, (byte)(bits >>> 16));
            this.byteBuffer.set(o + 3, (byte)(bits >>> 24));
        } else if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 3, (byte)bits);
            this.byteBuffer.set(o + 2, (byte)(bits >>> 8));
            this.byteBuffer.set(o + 1, (byte)(bits >>> 16));
            this.byteBuffer.set(o, (byte)(bits >>> 24));
        }
    }

    public void writeDouble(ByteOrder order, double value) {
        this.writeDouble(this.byteIndex, order, value);
    }

    public void writeDouble(int offset, ByteOrder order, double value) {
        int o = this.byteBuffer.reverse(offset);
        long bits = Double.doubleToRawLongBits(value);
        this.byteIndex = o + 8;
        if (order == ByteOrder.BIG) {
            this.byteBuffer.set(o + 7, (byte)bits);
            this.byteBuffer.set(o + 6, (byte)(bits >>> 8));
            this.byteBuffer.set(o + 5, (byte)(bits >>> 16));
            this.byteBuffer.set(o + 4, (byte)(bits >>> 24));
            this.byteBuffer.set(o + 3, (byte)(bits >>> 32));
            this.byteBuffer.set(o + 2, (byte)(bits >>> 40));
            this.byteBuffer.set(o + 1, (byte)(bits >>> 48));
            this.byteBuffer.set(o, (byte)(bits >>> 56));
        } else {
            this.byteBuffer.set(o, (byte)bits);
            this.byteBuffer.set(o + 1, (byte)(bits >>> 8));
            this.byteBuffer.set(o + 2, (byte)(bits >>> 16));
            this.byteBuffer.set(o + 3, (byte)(bits >>> 24));
            this.byteBuffer.set(o + 4, (byte)(bits >>> 32));
            this.byteBuffer.set(o + 5, (byte)(bits >>> 40));
            this.byteBuffer.set(o + 6, (byte)(bits >>> 48));
            this.byteBuffer.set(o + 7, (byte)(bits >>> 56));
        }
    }

    public void writeBytes(byte[] values) {
        this.writeBytes(this.byteIndex, values);
    }

    public void writeBytes(int offset, byte[] values) {
        int o = this.byteBuffer.reverse(offset);
        this.byteIndex = o + values.length;
        IntStream.range(0, values.length).forEach(i -> this.byteBuffer.set(o + i, values[i]));
    }

    public void align(int alignment) {
        if (alignment <= 0 || (alignment & 1) != 0) {
            throw new IllegalArgumentException("alignment must be a positive even number");
        }
        int index = this.byteIndex;
        int after = index + (alignment - 1) & ~(alignment - 1);
        this.byteIndex = Math.max(after, 0);
    }

    public void skip() {
        ++this.byteIndex;
    }

    public void skip(int num) {
        if (num >= 0) {
            this.byteIndex += num;
        } else {
            throw new IllegalArgumentException("num must be a positive number.");
        }
    }

    public ByteBuffer toByteBuffer() {
        return this.byteBuffer;
    }
}

