/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.indunet.fastproto.annotation.AsciiArrayType;
import org.indunet.fastproto.annotation.AsciiType;
import org.indunet.fastproto.annotation.BoolArrayType;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.annotation.DoubleArrayType;
import org.indunet.fastproto.annotation.DoubleType;
import org.indunet.fastproto.annotation.EnumType;
import org.indunet.fastproto.annotation.FloatArrayType;
import org.indunet.fastproto.annotation.FloatType;
import org.indunet.fastproto.annotation.Int16ArrayType;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.annotation.Int32ArrayType;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.annotation.Int64ArrayType;
import org.indunet.fastproto.annotation.Int64Type;
import org.indunet.fastproto.annotation.Int8ArrayType;
import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.annotation.StringType;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.exception.ResolveException;

public class AnnotationMapper {
    protected static Map<Predicate<Type>, Class<? extends Annotation>> map = new HashMap<Predicate<Type>, Class<? extends Annotation>>();

    public static Class<? extends Annotation> get(Type type) {
        return map.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(type)).map(Map.Entry::getValue).findAny().orElseThrow(() -> new ResolveException(String.format("Type %s is not supported.", type)));
    }

    static {
        BiFunction<Type, Class, Boolean> collectionType = (t, c) -> t instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType()) && ((ParameterizedType)t).getActualTypeArguments()[0].equals(c);
        map.put(c -> c.equals(Byte.TYPE) || c.equals(Byte.class), Int8Type.class);
        map.put(c -> c.equals(byte[].class), Int8ArrayType.class);
        map.put(c -> c.equals(Byte[].class), Int8ArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Byte.class), Int8ArrayType.class);
        map.put(c -> c.equals(Short.TYPE) || c.equals(Short.class), Int16Type.class);
        map.put(c -> c.equals(short[].class), Int16ArrayType.class);
        map.put(c -> c.equals(Short[].class), Int16ArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Short.class), Int16ArrayType.class);
        map.put(c -> c.equals(Integer.TYPE) || c.equals(Integer.class), Int32Type.class);
        map.put(c -> c.equals(int[].class), Int32ArrayType.class);
        map.put(c -> c.equals(Integer[].class), Int32ArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Integer.class), Int32ArrayType.class);
        map.put(c -> c.equals(Long.TYPE) || c.equals(Long.class), Int64Type.class);
        map.put(c -> c.equals(long[].class), Int64ArrayType.class);
        map.put(c -> c.equals(Long[].class), Int64ArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Long.class), Int64ArrayType.class);
        map.put(c -> c.equals(Float.TYPE) || c.equals(Float.class), FloatType.class);
        map.put(c -> c.equals(float[].class), FloatArrayType.class);
        map.put(c -> c.equals(Float[].class), FloatArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Float.class), FloatArrayType.class);
        map.put(c -> c.equals(Double.TYPE) || c.equals(Double.class), DoubleType.class);
        map.put(c -> c.equals(double[].class) || c.equals(Double[].class), DoubleArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Double.class), DoubleArrayType.class);
        map.put(c -> c.equals(Boolean.TYPE) || c.equals(Boolean.class), BoolType.class);
        map.put(c -> c.equals(boolean[].class) || c.equals(Boolean[].class), BoolType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Character.class), BoolArrayType.class);
        map.put(c -> c.equals(Character.TYPE) || c.equals(Character.class), AsciiType.class);
        map.put(c -> c.equals(char[].class) || c.equals(Character[].class), AsciiArrayType.class);
        map.put(t -> (Boolean)collectionType.apply((Type)t, Character.class), AsciiArrayType.class);
        map.put(c -> c.equals(Date.class), TimeType.class);
        map.put(c -> c.equals(Timestamp.class), TimeType.class);
        map.put(c -> c.equals(Calendar.class), TimeType.class);
        map.put(c -> c.equals(Instant.class), TimeType.class);
        map.put(c -> c.equals(LocalDateTime.class), TimeType.class);
        map.put(c -> c.equals(String.class), StringType.class);
        map.put(c -> c.equals(StringBuffer.class), StringType.class);
        map.put(c -> c.equals(StringBuilder.class), StringType.class);
        map.put(t -> t instanceof Class && Enum.class.isAssignableFrom((Class)t), EnumType.class);
    }
}

