/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.util.List;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class DecodeFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Reference reference = context.getGraph().root();
        ByteBufferInputStream inputStream = context.getInputStream();
        context.setObject(this.linearDecode(inputStream, context.getGraph()));
        this.forward(context);
    }

    public Object linearDecode(ByteBufferInputStream inputStream, Graph graph) {
        List<Reference> refs = graph.getValidReferences();
        refs.stream().filter(r -> r.getDecodingIgnore() == false).forEach(r -> {
            try {
                r.decode(inputStream);
            }
            catch (DecodingException e) {
                throw new DecodingException(String.format("Fail decoding field %s", r.getField().toString()), e);
            }
        });
        return graph.generate();
    }

    @Override
    public long getCode() {
        return 1L;
    }
}

