/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.io.ByteBuffer;

public class CodecUtils {
    public static int reverse(byte[] datagram, int offset) {
        int o;
        int n = o = offset >= 0 ? offset : datagram.length + offset;
        if (o >= 0) {
            return o;
        }
        throw new IllegalArgumentException(String.format("Illegal offset %d", o));
    }

    public static int reverse(byte[] datagram, int offset, int length) {
        int l;
        int o = CodecUtils.reverse(datagram, offset);
        int n = l = length >= 0 ? length : datagram.length + length - o + 1;
        if (l > 0) {
            return l;
        }
        throw new IllegalArgumentException(String.format("Illegal length %d", l));
    }

    public static byte[] binaryType(byte[] datagram, int offset, int length) {
        int l;
        int o = CodecUtils.reverse(datagram, offset);
        if (o + (l = CodecUtils.reverse(datagram, offset, length)) > datagram.length) {
            throw new IllegalArgumentException("Out of the datagram range.");
        }
        return Arrays.copyOfRange(datagram, o, o + l);
    }

    public static void binaryType(byte[] datagram, int offset, int length, byte[] values) {
        int l;
        int o = CodecUtils.reverse(datagram, offset);
        if (o + (l = CodecUtils.reverse(datagram, offset, length)) > datagram.length) {
            throw new IllegalArgumentException("Out of the datagram range.");
        }
        System.arraycopy(values, 0, datagram, o, Math.min(l, values.length));
    }

    public static void binaryType(ByteBuffer buffer, int offset, int length, byte[] values) {
        int l = buffer.reverse(offset, length);
        IntStream.range(0, Math.min(l, values.length)).forEach(i -> buffer.set(offset + i, values[i]));
    }

    public static boolean boolType(byte[] datagram, int byteOffset, int bitOffset, BitOrder order) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int o = CodecUtils.reverse(datagram, byteOffset);
        if (order == BitOrder.MSB_0) {
            bitOffset = 7 - bitOffset;
        }
        return (datagram[o] & 1 << bitOffset) != 0;
    }

    public static void boolType(byte[] datagram, int byteOffset, int bitOffset, BitOrder order, boolean value) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int o = CodecUtils.reverse(datagram, byteOffset);
        if (order == BitOrder.MSB_0) {
            bitOffset = 7 - bitOffset;
        }
        if (value) {
            int n = o;
            datagram[n] = (byte)(datagram[n] | 1 << bitOffset);
        } else {
            int n = o;
            datagram[n] = (byte)(datagram[n] & ~(1 << bitOffset));
        }
    }

    public static void boolType(ByteBuffer byteBuffer, int byteOffset, int bitOffset, BitOrder bitOrder, boolean value) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int bo = bitOffset;
        if (bitOrder == BitOrder.MSB_0) {
            bo = 7 - bitOffset;
        }
        if (value) {
            byteBuffer.orEq(byteOffset, (byte)(1 << bo));
        } else {
            byteBuffer.andEq(byteOffset, (byte)(~(1 << bo)));
        }
    }

    public static byte byteType(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset);
    }

    public static byte byteType(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o];
    }

    public static void byteType(@NonNull byte[] datagram, int offset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = value;
    }

    public static void byteType(ByteBuffer byteBuffer, int offset, byte value) {
        byteBuffer.set(offset, value);
    }

    public static int uint8Type(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset) & 0xFF;
    }

    public static int uint8Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o] & 0xFF;
    }

    public static void uint8Type(@NonNull byte[] datagram, int offset, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Out of uint8 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = (byte)value;
    }

    public static void uint8Type(ByteBuffer byteArray, int offset, int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Out of uint8 range.");
        }
        int o = CodecUtils.reverse(byteArray.toBytes(), offset);
        byteArray.set(o, (byte)value);
    }

    public static int int8Type(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset);
    }

    public static int int8Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o];
    }

    public static void int8Type(@NonNull byte[] datagram, int offset, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = (byte)value;
    }

    public static void int8Type(ByteBuffer byteBuffer, int offset, int value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        byteBuffer.set(offset, (byte)value);
    }

    public static int uint16Type(byte[] datagram, int offset, ByteOrder byteOrder) {
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            return (datagram[o] & 0xFF) * 256 + (datagram[o + 1] & 0xFF);
        }
        return (datagram[o + 1] & 0xFF) * 256 + (datagram[o] & 0xFF);
    }

    public static int uint16Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.BIG) {
            return (buffer.get(o) & 0xFF) * 256 + (buffer.get(o + 1) & 0xFF);
        }
        return (buffer.get(o) & 0xFF) + (buffer.get(o + 1) & 0xFF) * 256;
    }

    public static void uint16Type(byte[] datagram, int offset, ByteOrder byteOrder, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Out of uint16 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void uint16Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Out of uint16 range.");
        }
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 1, (byte)value);
            buffer.set(o, (byte)(value >>> 8));
        } else {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
        }
    }

    public static int int16Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | datagram[o + 1] & 0xFF);
            value = (short)(value | datagram[o] << 8);
        } else {
            value = (short)(value | datagram[o] & 0xFF);
            value = (short)(value | datagram[o + 1] << 8);
        }
        return value;
    }

    public static int int16Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        int value = 0;
        if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | buffer.get(o) << 8);
            value = (short)(value | buffer.get(o + 1) & 0xFF);
        } else {
            value = (short)(value | buffer.get(o) & 0xFF);
            value = (short)(value | buffer.get(o + 1) << 8);
        }
        return value;
    }

    public static void int16Type(byte[] datagram, int offset, ByteOrder byteOrder, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Out of int16 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void int16Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Out of int16 range.");
        }
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 1, (byte)value);
            buffer.set(o, (byte)(value >>> 8));
        } else {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
        }
    }

    public static short shortType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        short value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value = (short)(value | datagram[o] & 0xFF);
            value = (short)(value | datagram[o + 1] << 8);
        } else if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | datagram[o + 1] & 0xFF);
            value = (short)(value | datagram[o] << 8);
        }
        return value;
    }

    public static short shortType(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        short value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value = (short)(value | buffer.get(o) & 0xFF);
            value = (short)(value | buffer.get(o + 1) << 8);
        } else if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | buffer.get(o) << 8);
            value = (short)(value | buffer.get(o + 1) & 0xFF);
        }
        return value;
    }

    public static void shortType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, short value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        }
    }

    public static void shortType(ByteBuffer buffer, int offset, ByteOrder byteOrder, short value) {
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.LITTLE) {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
        } else if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 1, (byte)value);
            buffer.set(o, (byte)(value >>> 8));
        }
    }

    public static int int32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= datagram[o] & 0xFF;
            value |= (datagram[o + 1] & 0xFF) << 8;
            value |= (datagram[o + 2] & 0xFF) << 16;
            value |= (datagram[o + 3] & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= datagram[o + 3] & 0xFF;
            value |= (datagram[o + 2] & 0xFF) << 8;
            value |= (datagram[o + 1] & 0xFF) << 16;
            value |= (datagram[o] & 0xFF) << 24;
        }
        return value;
    }

    public static int int32Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= buffer.get(o) & 0xFF;
            value |= (buffer.get(o + 1) & 0xFF) << 8;
            value |= (buffer.get(o + 2) & 0xFF) << 16;
            value |= (buffer.get(o + 3) & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (buffer.get(o) & 0xFF) << 24;
            value |= (buffer.get(o + 1) & 0xFF) << 16;
            value |= (buffer.get(o + 2) & 0xFF) << 8;
            value |= buffer.get(o + 3) & 0xFF;
        }
        return value;
    }

    public static void int32Type(byte[] datagram, int offset, ByteOrder byteOrder, int value) {
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)value;
            datagram[o + 2] = (byte)(value >>> 8);
            datagram[o + 1] = (byte)(value >>> 16);
            datagram[o] = (byte)(value >>> 24);
        }
    }

    public static void int32Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, int value) {
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.LITTLE) {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
            buffer.set(o + 2, (byte)(value >>> 16));
            buffer.set(o + 3, (byte)(value >>> 24));
        } else if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 3, (byte)value);
            buffer.set(o + 2, (byte)(value >>> 8));
            buffer.set(o + 1, (byte)(value >>> 16));
            buffer.set(o, (byte)(value >>> 24));
        }
    }

    public static long uint32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(datagram[o] & 0xFF);
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)(datagram[o + 3] & 0xFF);
            value |= ((long)datagram[o + 2] & 0xFFL) << 8;
            value |= ((long)datagram[o + 1] & 0xFFL) << 16;
            value |= ((long)datagram[o] & 0xFFL) << 24;
        }
        return value;
    }

    public static long uint32Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(buffer.get(o) & 0xFF);
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 3) & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)buffer.get(o) & 0xFFL) << 24;
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 8;
            value |= (long)(buffer.get(o + 3) & 0xFF);
        }
        return value;
    }

    public static void uint32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Out of uint32 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)value;
            datagram[o + 2] = (byte)(value >>> 8);
            datagram[o + 1] = (byte)(value >>> 16);
            datagram[o] = (byte)(value >>> 24);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
        }
    }

    public static void uint32Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Out of uint32 range.");
        }
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 3, (byte)value);
            buffer.set(o + 2, (byte)(value >>> 8));
            buffer.set(o + 1, (byte)(value >>> 16));
            buffer.set(o, (byte)(value >>> 24));
        } else {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
            buffer.set(o + 2, (byte)(value >>> 16));
            buffer.set(o + 3, (byte)(value >>> 24));
        }
    }

    public static BigInteger uint64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long low = 0L;
        long high = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            low |= (long)(datagram[o] & 0xFF);
            low |= ((long)datagram[o + 1] & 0xFFL) << 8;
            low |= ((long)datagram[o + 2] & 0xFFL) << 16;
            low |= ((long)datagram[o + 3] & 0xFFL) << 24;
            high |= (long)datagram[o + 4] & 0xFFL;
            high |= ((long)datagram[o + 5] & 0xFFL) << 8;
            high |= ((long)datagram[o + 6] & 0xFFL) << 16;
            high |= ((long)datagram[o + 7] & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            low |= (long)(datagram[o + 7] & 0xFF);
            low |= ((long)datagram[o + 6] & 0xFFL) << 8;
            low |= ((long)datagram[o + 5] & 0xFFL) << 16;
            low |= ((long)datagram[o + 4] & 0xFFL) << 24;
            high |= (long)datagram[o + 3] & 0xFFL;
            high |= ((long)datagram[o + 2] & 0xFFL) << 8;
            high |= ((long)datagram[o + 1] & 0xFFL) << 16;
            high |= ((long)datagram[o] & 0xFFL) << 24;
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public static BigInteger uint64Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        long low = 0L;
        long high = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            low |= (long)(buffer.get(o) & 0xFF);
            low |= ((long)buffer.get(o + 1) & 0xFFL) << 8;
            low |= ((long)buffer.get(o + 2) & 0xFFL) << 16;
            low |= ((long)buffer.get(o + 3) & 0xFFL) << 24;
            high |= (long)buffer.get(o + 4) & 0xFFL;
            high |= ((long)buffer.get(o + 5) & 0xFFL) << 8;
            high |= ((long)buffer.get(o + 6) & 0xFFL) << 16;
            high |= ((long)buffer.get(o + 7) & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            high |= ((long)buffer.get(o) & 0xFFL) << 24;
            high |= ((long)buffer.get(o + 1) & 0xFFL) << 16;
            high |= ((long)buffer.get(o + 2) & 0xFFL) << 8;
            high |= (long)buffer.get(o + 3) & 0xFFL;
            low |= ((long)buffer.get(o + 4) & 0xFFL) << 24;
            low |= ((long)buffer.get(o + 5) & 0xFFL) << 16;
            low |= ((long)buffer.get(o + 6) & 0xFFL) << 8;
            low |= (long)(buffer.get(o + 7) & 0xFF);
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public static void uint64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Out of uinteger64 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)low;
            datagram[o + 6] = (byte)(low >>> 8);
            datagram[o + 5] = (byte)(low >>> 16);
            datagram[o + 4] = (byte)(low >>> 24);
            datagram[o + 3] = (byte)high;
            datagram[o + 2] = (byte)(high >>> 8);
            datagram[o + 1] = (byte)(high >>> 16);
            datagram[o] = (byte)(high >>> 24);
        } else {
            datagram[o] = (byte)low;
            datagram[o + 1] = (byte)(low >>> 8);
            datagram[o + 2] = (byte)(low >>> 16);
            datagram[o + 3] = (byte)(low >>> 24);
            datagram[o + 4] = (byte)high;
            datagram[o + 5] = (byte)(high >>> 8);
            datagram[o + 6] = (byte)(high >>> 16);
            datagram[o + 7] = (byte)(high >>> 24);
        }
    }

    public static void uint64Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, BigInteger value) {
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Out of uinteger64 range.");
        }
        int o = buffer.reverse(offset);
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 7, (byte)low);
            buffer.set(o + 6, (byte)(low >>> 8));
            buffer.set(o + 5, (byte)(low >>> 16));
            buffer.set(o + 4, (byte)(low >>> 24));
            buffer.set(o + 3, (byte)high);
            buffer.set(o + 2, (byte)(high >>> 8));
            buffer.set(o + 1, (byte)(high >>> 16));
            buffer.set(o, (byte)(high >>> 24));
        } else {
            buffer.set(o, (byte)low);
            buffer.set(o + 1, (byte)(low >>> 8));
            buffer.set(o + 2, (byte)(low >>> 16));
            buffer.set(o + 3, (byte)(low >>> 24));
            buffer.set(o + 4, (byte)high);
            buffer.set(o + 5, (byte)(high >>> 8));
            buffer.set(o + 6, (byte)(high >>> 16));
            buffer.set(o + 7, (byte)(high >>> 24));
        }
    }

    public static long int64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(datagram[o] & 0xFF);
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
            value |= ((long)datagram[o + 4] & 0xFFL) << 32;
            value |= ((long)datagram[o + 5] & 0xFFL) << 40;
            value |= ((long)datagram[o + 6] & 0xFFL) << 48;
            value |= ((long)datagram[o + 7] & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)(datagram[o + 7] & 0xFF);
            value |= ((long)datagram[o + 6] & 0xFFL) << 8;
            value |= ((long)datagram[o + 5] & 0xFFL) << 16;
            value |= ((long)datagram[o + 4] & 0xFFL) << 24;
            value |= ((long)datagram[o + 3] & 0xFFL) << 32;
            value |= ((long)datagram[o + 2] & 0xFFL) << 40;
            value |= ((long)datagram[o + 1] & 0xFFL) << 48;
            value |= ((long)datagram[o] & 0xFFL) << 56;
        }
        return value;
    }

    public static long int64Type(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(buffer.get(o) & 0xFF);
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 3) & 0xFFL) << 24;
            value |= ((long)buffer.get(o + 4) & 0xFFL) << 32;
            value |= ((long)buffer.get(o + 5) & 0xFFL) << 40;
            value |= ((long)buffer.get(o + 6) & 0xFFL) << 48;
            value |= ((long)buffer.get(o + 7) & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)buffer.get(o) & 0xFFL) << 56;
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 48;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 40;
            value |= ((long)buffer.get(o + 3) & 0xFFL) << 32;
            value |= ((long)buffer.get(o + 4) & 0xFFL) << 24;
            value |= ((long)buffer.get(o + 5) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 6) & 0xFFL) << 8;
            value |= (long)(buffer.get(o + 7) & 0xFF);
        }
        return value;
    }

    public static void int64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)value;
            datagram[o + 6] = (byte)(value >>> 8);
            datagram[o + 5] = (byte)(value >>> 16);
            datagram[o + 4] = (byte)(value >>> 24);
            datagram[o + 3] = (byte)(value >>> 32);
            datagram[o + 2] = (byte)(value >>> 40);
            datagram[o + 1] = (byte)(value >>> 48);
            datagram[o] = (byte)(value >>> 56);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
            datagram[o + 4] = (byte)(value >>> 32);
            datagram[o + 5] = (byte)(value >>> 40);
            datagram[o + 6] = (byte)(value >>> 48);
            datagram[o + 7] = (byte)(value >>> 56);
        }
    }

    public static void int64Type(ByteBuffer buffer, int offset, ByteOrder byteOrder, long value) {
        int o = buffer.reverse(offset);
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 7, (byte)value);
            buffer.set(o + 6, (byte)(value >>> 8));
            buffer.set(o + 5, (byte)(value >>> 16));
            buffer.set(o + 4, (byte)(value >>> 24));
            buffer.set(o + 3, (byte)(value >>> 32));
            buffer.set(o + 2, (byte)(value >>> 40));
            buffer.set(o + 1, (byte)(value >>> 48));
            buffer.set(o, (byte)(value >>> 56));
        } else {
            buffer.set(o, (byte)value);
            buffer.set(o + 1, (byte)(value >>> 8));
            buffer.set(o + 2, (byte)(value >>> 16));
            buffer.set(o + 3, (byte)(value >>> 24));
            buffer.set(o + 4, (byte)(value >>> 32));
            buffer.set(o + 5, (byte)(value >>> 40));
            buffer.set(o + 6, (byte)(value >>> 48));
            buffer.set(o + 7, (byte)(value >>> 56));
        }
    }

    public static float floatType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= datagram[o] & 0xFF;
            value |= (datagram[o + 1] & 0xFF) << 8;
            value |= (datagram[o + 2] & 0xFF) << 16;
            value |= (datagram[o + 3] & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= datagram[o + 3] & 0xFF;
            value |= (datagram[o + 2] & 0xFF) << 8;
            value |= (datagram[o + 1] & 0xFF) << 16;
            value |= (datagram[o] & 0xFF) << 24;
        }
        return Float.intBitsToFloat(value);
    }

    public static float floatType(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= buffer.get(o) & 0xFF;
            value |= (buffer.get(o + 1) & 0xFF) << 8;
            value |= (buffer.get(o + 2) & 0xFF) << 16;
            value |= (buffer.get(o + 3) & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (buffer.get(o) & 0xFF) << 24;
            value |= (buffer.get(o + 1) & 0xFF) << 16;
            value |= (buffer.get(o + 2) & 0xFF) << 8;
            value |= buffer.get(o + 3) & 0xFF;
        }
        return Float.intBitsToFloat(value);
    }

    public static void floatType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, float value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int bits = Float.floatToIntBits(value);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)bits;
            datagram[o + 1] = (byte)(bits >>> 8);
            datagram[o + 2] = (byte)(bits >>> 16);
            datagram[o + 3] = (byte)(bits >>> 24);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)bits;
            datagram[o + 2] = (byte)(bits >>> 8);
            datagram[o + 1] = (byte)(bits >>> 16);
            datagram[o] = (byte)(bits >>> 24);
        }
    }

    public static void floatType(ByteBuffer buffer, int offset, ByteOrder byteOrder, float value) {
        int o = buffer.reverse(offset);
        int bits = Float.floatToIntBits(value);
        if (byteOrder == ByteOrder.LITTLE) {
            buffer.set(o, (byte)bits);
            buffer.set(o + 1, (byte)(bits >>> 8));
            buffer.set(o + 2, (byte)(bits >>> 16));
            buffer.set(o + 3, (byte)(bits >>> 24));
        } else if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 3, (byte)bits);
            buffer.set(o + 2, (byte)(bits >>> 8));
            buffer.set(o + 1, (byte)(bits >>> 16));
            buffer.set(o, (byte)(bits >>> 24));
        }
    }

    public static double doubleType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)datagram[o] & 0xFFL;
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
            value |= ((long)datagram[o + 4] & 0xFFL) << 32;
            value |= ((long)datagram[o + 5] & 0xFFL) << 40;
            value |= ((long)datagram[o + 6] & 0xFFL) << 48;
            value |= ((long)datagram[o + 7] & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)datagram[o + 7] & 0xFFL;
            value |= ((long)datagram[o + 6] & 0xFFL) << 8;
            value |= ((long)datagram[o + 5] & 0xFFL) << 16;
            value |= ((long)datagram[o + 4] & 0xFFL) << 24;
            value |= ((long)datagram[o + 3] & 0xFFL) << 32;
            value |= ((long)datagram[o + 2] & 0xFFL) << 40;
            value |= ((long)datagram[o + 1] & 0xFFL) << 48;
            value |= ((long)datagram[o] & 0xFFL) << 56;
        }
        return Double.longBitsToDouble(value);
    }

    public static double doubleType(ByteBuffer buffer, int offset, ByteOrder byteOrder) {
        int o = buffer.reverse(offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)buffer.get(o) & 0xFFL;
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 8;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 3) & 0xFFL) << 24;
            value |= ((long)buffer.get(o + 4) & 0xFFL) << 32;
            value |= ((long)buffer.get(o + 5) & 0xFFL) << 40;
            value |= ((long)buffer.get(o + 6) & 0xFFL) << 48;
            value |= ((long)buffer.get(o + 7) & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)buffer.get(o) & 0xFFL) << 56;
            value |= ((long)buffer.get(o + 1) & 0xFFL) << 48;
            value |= ((long)buffer.get(o + 2) & 0xFFL) << 40;
            value |= ((long)buffer.get(o + 3) & 0xFFL) << 32;
            value |= ((long)buffer.get(o + 5) & 0xFFL) << 16;
            value |= ((long)buffer.get(o + 4) & 0xFFL) << 24;
            value |= ((long)buffer.get(o + 6) & 0xFFL) << 8;
            value |= (long)buffer.get(o + 7) & 0xFFL;
        }
        return Double.longBitsToDouble(value);
    }

    public static void doubleType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, double value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long bits = Double.doubleToRawLongBits(value);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)bits;
            datagram[o + 6] = (byte)(bits >>> 8);
            datagram[o + 5] = (byte)(bits >>> 16);
            datagram[o + 4] = (byte)(bits >>> 24);
            datagram[o + 3] = (byte)(bits >>> 32);
            datagram[o + 2] = (byte)(bits >>> 40);
            datagram[o + 1] = (byte)(bits >>> 48);
            datagram[o] = (byte)(bits >>> 56);
        } else {
            datagram[o] = (byte)bits;
            datagram[o + 1] = (byte)(bits >>> 8);
            datagram[o + 2] = (byte)(bits >>> 16);
            datagram[o + 3] = (byte)(bits >>> 24);
            datagram[o + 4] = (byte)(bits >>> 32);
            datagram[o + 5] = (byte)(bits >>> 40);
            datagram[o + 6] = (byte)(bits >>> 48);
            datagram[o + 7] = (byte)(bits >>> 56);
        }
    }

    public static void doubleType(ByteBuffer buffer, int offset, ByteOrder byteOrder, double value) {
        int o = buffer.reverse(offset);
        long bits = Double.doubleToRawLongBits(value);
        if (byteOrder == ByteOrder.BIG) {
            buffer.set(o + 7, (byte)bits);
            buffer.set(o + 6, (byte)(bits >>> 8));
            buffer.set(o + 5, (byte)(bits >>> 16));
            buffer.set(o + 4, (byte)(bits >>> 24));
            buffer.set(o + 3, (byte)(bits >>> 32));
            buffer.set(o + 2, (byte)(bits >>> 40));
            buffer.set(o + 1, (byte)(bits >>> 48));
            buffer.set(o, (byte)(bits >>> 56));
        } else {
            buffer.set(o, (byte)bits);
            buffer.set(o + 1, (byte)(bits >>> 8));
            buffer.set(o + 2, (byte)(bits >>> 16));
            buffer.set(o + 3, (byte)(bits >>> 24));
            buffer.set(o + 4, (byte)(bits >>> 32));
            buffer.set(o + 5, (byte)(bits >>> 40));
            buffer.set(o + 6, (byte)(bits >>> 48));
            buffer.set(o + 7, (byte)(bits >>> 56));
        }
    }
}

