/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.annotation.BoolArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class BoolArrayCodec
implements Codec<boolean[]> {
    @Override
    public boolean[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            BoolArrayType type = context.getDataTypeAnnotation(BoolArrayType.class);
            BitOrder order = context.getBitOrder(type::bitOrder);
            boolean[] bools = new boolean[type.length()];
            int byteIndex = type.byteOffset() + type.bitOffset() / 8;
            int bitIndex = type.bitOffset() % 8;
            for (int i = 0; i < type.length(); ++i) {
                bools[i] = inputStream.readBool(byteIndex, bitIndex, order);
                if (++bitIndex != 8) continue;
                bitIndex = 0;
                ++byteIndex;
            }
            return bools;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding boolean array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, boolean[] bools) {
        try {
            BoolArrayType type = context.getDataTypeAnnotation(BoolArrayType.class);
            BitOrder order = context.getBitOrder(type::bitOrder);
            int byteIndex = type.byteOffset() + type.bitOffset() / 8;
            int bitIndex = type.bitOffset() % 8;
            for (int i = 0; i < Math.min(type.length(), bools.length); ++i) {
                outputStream.writeBool(byteIndex, bitIndex, order, bools[i]);
                if (++bitIndex != 8) continue;
                bitIndex = 0;
                ++byteIndex;
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding boolean array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Boolean>> {
        @Override
        public Collection<Boolean> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (boolean value : BoolArrayCodec.this.decode(context, inputStream)) {
                    collection.add(value);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Boolean> collection) {
            boolean[] bools = new boolean[collection.size()];
            Boolean[] values = (Boolean[])collection.stream().toArray(Boolean[]::new);
            IntStream.range(0, values.length).forEach(i -> {
                bools[i] = values[i];
            });
            BoolArrayCodec.this.encode(context, outputStream, bools);
        }
    }

    public class WrapperCodec
    implements Codec<Boolean[]> {
        @Override
        public Boolean[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            boolean[] bools = BoolArrayCodec.this.decode(context, inputStream);
            Boolean[] results = new Boolean[bools.length];
            IntStream.range(0, bools.length).forEach(i -> {
                results[i] = bools[i];
            });
            return results;
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Boolean[] values) {
            boolean[] bools = new boolean[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                bools[i] = values[i];
            });
            BoolArrayCodec.this.encode(context, outputStream, bools);
        }
    }
}

