/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.annotation.EnumType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class EnumCodec<T extends Enum>
implements Codec<T> {
    @Override
    public T decode(CodecContext context, ByteBufferInputStream inputStream) {
        EnumType type = context.getDataTypeAnnotation(EnumType.class);
        Class<?> enumClass = context.getFieldType();
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        int code = inputStream.readUInt8(type.offset());
        String name = type.name();
        if (name == null || name.isEmpty()) {
            return (T)Arrays.stream(enums).filter(e -> e.ordinal() == code).findAny().orElseThrow(() -> new DecodingException(String.format("Enum with code %s cannot be found.", code)));
        }
        Function<Enum, Integer> getValue = enumObject -> {
            Field field = null;
            try {
                field = enumClass.getDeclaredField(name);
                field.setAccessible(true);
                return field.getInt(enumObject);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new DecodingException(String.format("Illegal enum field %s", name), e);
            }
        };
        return (T)Arrays.stream(enums).filter(e -> (Integer)getValue.apply((Enum)e) == code).findAny().orElseThrow(() -> new DecodingException(String.format("Enum with code %s cannot be found.", code)));
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, T value) {
        EnumType type = context.getDataTypeAnnotation(EnumType.class);
        String name = type.name();
        int code = 0;
        if (name == null || name.isEmpty()) {
            code = ((Enum)value).ordinal();
        } else {
            try {
                Field field = value.getClass().getDeclaredField(name);
                field.setAccessible(true);
                code = field.getInt(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new EncodingException(String.format("Illegal enum field %s", name), e);
            }
        }
        outputStream.writeUInt8(type.offset(), code);
    }
}

